/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls.handshake;

import java.nio.ByteBuffer;
import java.util.List;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.TlsProtocolException;
import net.luminis.tls.alert.DecodeErrorException;
import net.luminis.tls.alert.IllegalParameterAlert;
import net.luminis.tls.alert.UnsupportedExtensionAlert;
import net.luminis.tls.extension.EarlyDataExtension;
import net.luminis.tls.extension.Extension;
import net.luminis.tls.extension.UnknownExtension;
import net.luminis.tls.handshake.EncryptedExtensions;
import net.luminis.tls.handshake.HandshakeMessage;

public class NewSessionTicketMessage
extends HandshakeMessage {
    private static final int MINIMUM_MESSAGE_SIZE = 17;
    private long ticketAgeAdd;
    private byte[] ticket;
    private byte[] ticketNonce;
    private int ticketLifetime;
    private EarlyDataExtension earlyDataExtension;

    public NewSessionTicketMessage parse(ByteBuffer buffer, int length) throws TlsProtocolException {
        int remainingLength = this.parseHandshakeHeader(buffer, TlsConstants.HandshakeType.new_session_ticket, 17);
        this.ticketLifetime = buffer.getInt();
        remainingLength -= 4;
        if (this.ticketLifetime > 604800 || this.ticketLifetime < 0) {
            throw new IllegalParameterAlert("Invalid ticket lifetime");
        }
        this.ticketAgeAdd = (long)buffer.getInt() & 0xFFFFFFFFL;
        this.ticketNonce = this.parseByteVector(buffer, 1, remainingLength -= 4, "ticket nonce");
        this.ticket = this.parseByteVector(buffer, 2, remainingLength -= 1 + this.ticketNonce.length, "ticket");
        List<Extension> extensions = EncryptedExtensions.parseExtensions(buffer, TlsConstants.HandshakeType.new_session_ticket);
        for (Extension extension : extensions) {
            int type;
            if (extension instanceof EarlyDataExtension) {
                if (this.earlyDataExtension == null) {
                    this.earlyDataExtension = (EarlyDataExtension)extension;
                    continue;
                }
                throw new UnsupportedExtensionAlert("Only one early data extension is allowed");
            }
            if (!(extension instanceof UnknownExtension) || ((type = ((UnknownExtension)extension).getType()) & 0xA0A) == 2570) continue;
            throw new UnsupportedExtensionAlert("Only early data extension is allowed");
        }
        return this;
    }

    private byte[] parseByteVector(ByteBuffer buffer, int lengthBytes, int remainingMessageLength, String fieldName) throws DecodeErrorException {
        if (remainingMessageLength < lengthBytes) {
            throw new DecodeErrorException("No length specified for " + fieldName);
        }
        int vectorSize = 0;
        for (int i = 0; i < lengthBytes; ++i) {
            vectorSize = vectorSize << 8 | buffer.get() & 0xFF;
        }
        if ((remainingMessageLength -= lengthBytes) < vectorSize) {
            throw new DecodeErrorException("Message too short for given length of " + fieldName);
        }
        byte[] byteVector = new byte[vectorSize];
        buffer.get(byteVector);
        return byteVector;
    }

    @Override
    public TlsConstants.HandshakeType getType() {
        return TlsConstants.HandshakeType.new_session_ticket;
    }

    @Override
    public byte[] getBytes() {
        return new byte[0];
    }

    public int getTicketLifetime() {
        return this.ticketLifetime;
    }

    public long getTicketAgeAdd() {
        return this.ticketAgeAdd;
    }

    public byte[] getTicket() {
        return this.ticket;
    }

    public byte[] getTicketNonce() {
        return this.ticketNonce;
    }

    public EarlyDataExtension getEarlyDataExtension() {
        return this.earlyDataExtension;
    }
}

