/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls.handshake;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.stream.Stream;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.TlsProtocolException;
import net.luminis.tls.alert.DecodeErrorException;
import net.luminis.tls.handshake.HandshakeMessage;

public class CertificateVerifyMessage
extends HandshakeMessage {
    private static final int MINIMUM_MESSAGE_SIZE = 9;
    private TlsConstants.SignatureScheme signatureScheme;
    private byte[] signature;
    private byte[] raw;

    public CertificateVerifyMessage(TlsConstants.SignatureScheme signatureScheme, byte[] signature) {
        this.signatureScheme = signatureScheme;
        this.signature = signature;
        this.serialize();
    }

    public CertificateVerifyMessage() {
    }

    @Override
    public TlsConstants.HandshakeType getType() {
        return TlsConstants.HandshakeType.certificate_verify;
    }

    public CertificateVerifyMessage parse(ByteBuffer buffer, int length) throws TlsProtocolException {
        int startPosition = buffer.position();
        int remainingLength = this.parseHandshakeHeader(buffer, TlsConstants.HandshakeType.certificate_verify, 9);
        try {
            short signatureSchemeValue = buffer.getShort();
            this.signatureScheme = Stream.of(TlsConstants.SignatureScheme.values()).filter(it -> it.value == signatureSchemeValue).findAny().orElseThrow(() -> new DecodeErrorException("Unknown signature schema"));
            short signatureLength = buffer.getShort();
            this.signature = new byte[signatureLength];
            buffer.get(this.signature);
            if (buffer.position() - startPosition != 4 + remainingLength) {
                throw new DecodeErrorException("Incorrect message length");
            }
            this.raw = new byte[length];
            buffer.position(startPosition);
            buffer.get(this.raw);
            return this;
        }
        catch (BufferUnderflowException notEnoughBytes) {
            throw new DecodeErrorException("message underflow");
        }
    }

    @Override
    public byte[] getBytes() {
        return this.raw;
    }

    private void serialize() {
        int signatureLength = this.signature.length;
        ByteBuffer buffer = ByteBuffer.allocate(8 + signatureLength);
        buffer.putInt(TlsConstants.HandshakeType.certificate_verify.value << 24 | 4 + signatureLength);
        buffer.putShort(this.signatureScheme.value);
        buffer.putShort((short)signatureLength);
        buffer.put(this.signature);
        this.raw = buffer.array();
    }

    public TlsConstants.SignatureScheme getSignatureScheme() {
        return this.signatureScheme;
    }

    public byte[] getSignature() {
        return this.signature;
    }
}

