/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls.extension;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.alert.DecodeErrorException;
import net.luminis.tls.extension.Extension;

public class PskKeyExchangeModesExtension
extends Extension {
    private final List<TlsConstants.PskKeyExchangeMode> keyExchangeModes = new ArrayList<TlsConstants.PskKeyExchangeMode>();

    public PskKeyExchangeModesExtension(TlsConstants.PskKeyExchangeMode keyExchangeMode) {
        this.keyExchangeModes.add(keyExchangeMode);
    }

    public PskKeyExchangeModesExtension(TlsConstants.PskKeyExchangeMode ... keyExchangeModes) {
        for (TlsConstants.PskKeyExchangeMode keyExchangeMode : keyExchangeModes) {
            this.keyExchangeModes.add(keyExchangeMode);
        }
    }

    public PskKeyExchangeModesExtension(ByteBuffer buffer) throws DecodeErrorException {
        int extensionDataLength = this.parseExtensionHeader(buffer, TlsConstants.ExtensionType.psk_key_exchange_modes, 2);
        int pskKeyExchangeModesLength = buffer.get();
        if (extensionDataLength != 1 + pskKeyExchangeModesLength) {
            throw new DecodeErrorException("inconsistent length");
        }
        for (int i = 0; i < pskKeyExchangeModesLength; ++i) {
            byte modeByte = buffer.get();
            if (modeByte == TlsConstants.PskKeyExchangeMode.psk_ke.value) {
                this.keyExchangeModes.add(TlsConstants.PskKeyExchangeMode.psk_ke);
                continue;
            }
            if (modeByte == TlsConstants.PskKeyExchangeMode.psk_dhe_ke.value) {
                this.keyExchangeModes.add(TlsConstants.PskKeyExchangeMode.psk_dhe_ke);
                continue;
            }
            throw new DecodeErrorException("invalid psk key exchange mocde");
        }
    }

    @Override
    public byte[] getBytes() {
        short extensionLength = (short)(1 + this.keyExchangeModes.size());
        ByteBuffer buffer = ByteBuffer.allocate(4 + extensionLength);
        buffer.putShort(TlsConstants.ExtensionType.psk_key_exchange_modes.value);
        buffer.putShort(extensionLength);
        buffer.put((byte)this.keyExchangeModes.size());
        this.keyExchangeModes.forEach(mode -> buffer.put(mode.value));
        return buffer.array();
    }

    public List<TlsConstants.PskKeyExchangeMode> getKeyExchangeModes() {
        return this.keyExchangeModes;
    }
}

