/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls.extension;

import java.nio.ByteBuffer;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.extension.Extension;

public class EarlyDataExtension
extends Extension {
    private Long maxEarlyDataSize;

    public Extension parse(ByteBuffer buffer) {
        short extensionType = buffer.getShort();
        if (extensionType != TlsConstants.ExtensionType.early_data.value) {
            throw new RuntimeException();
        }
        short extensionLength = buffer.getShort();
        if (extensionLength == 4) {
            this.maxEarlyDataSize = (long)buffer.getInt() & 0xFFFFFFFFL;
        }
        return this;
    }

    @Override
    public byte[] getBytes() {
        int extensionDataLength = this.maxEarlyDataSize == null ? 0 : 4;
        ByteBuffer buffer = ByteBuffer.allocate(4 + extensionDataLength);
        buffer.putShort(TlsConstants.ExtensionType.early_data.value);
        buffer.putShort((short)extensionDataLength);
        if (this.maxEarlyDataSize != null) {
            buffer.putInt((int)this.maxEarlyDataSize.longValue());
        }
        return buffer.array();
    }

    public long getMaxEarlyDataSize() {
        return this.maxEarlyDataSize;
    }

    public String toString() {
        return "EarlyDataExtension " + (String)(this.maxEarlyDataSize == null ? "(empty)" : "[" + this.maxEarlyDataSize + "]");
    }
}

