/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls.extension;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.extension.Extension;

public class ApplicationLayerProtocolNegotiationExtension
extends Extension {
    private final byte[] data;
    private List<String> protocols;

    public ApplicationLayerProtocolNegotiationExtension() {
        this.data = null;
    }

    public ApplicationLayerProtocolNegotiationExtension(String protocol) {
        byte[] protocolName = protocol.getBytes(Charset.forName("UTF-8"));
        this.protocols = List.of(protocol);
        ByteBuffer buffer = ByteBuffer.allocate(7 + protocolName.length);
        buffer.putShort(TlsConstants.ExtensionType.application_layer_protocol_negotiation.value);
        buffer.putShort((byte)(3 + protocolName.length));
        buffer.putShort((byte)(1 + protocolName.length));
        buffer.put((byte)protocolName.length);
        buffer.put(protocolName);
        this.data = new byte[buffer.limit()];
        buffer.flip();
        buffer.get(this.data);
    }

    public ApplicationLayerProtocolNegotiationExtension parse(ByteBuffer buffer) {
        int protocolNameLength;
        short extensionType = buffer.getShort();
        if (extensionType != TlsConstants.ExtensionType.application_layer_protocol_negotiation.value) {
            throw new RuntimeException();
        }
        short extensionLength = buffer.getShort();
        this.protocols = new ArrayList<String>();
        for (int protocolsLength = buffer.getShort(); protocolsLength > 0; protocolsLength -= 1 + protocolNameLength) {
            protocolNameLength = buffer.get() & 0xFF;
            byte[] protocolBytes = new byte[protocolNameLength];
            buffer.get(protocolBytes);
            this.protocols.add(new String(protocolBytes));
        }
        return this;
    }

    @Override
    public byte[] getBytes() {
        return this.data;
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    public String toString() {
        return "AlpnExtension " + this.protocols;
    }
}

