/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import net.luminis.quic.EncryptionLevel;
import net.luminis.quic.QuicConnectionImpl;
import net.luminis.quic.QuicStream;
import net.luminis.quic.Version;
import net.luminis.quic.frame.MaxStreamDataFrame;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.frame.ResetStreamFrame;
import net.luminis.quic.frame.StopSendingFrame;
import net.luminis.quic.frame.StreamFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.log.NullLogger;
import net.luminis.quic.stream.BaseStream;
import net.luminis.quic.stream.FlowControl;
import net.luminis.quic.stream.FlowControlUpdateListener;

public class QuicStreamImpl
extends BaseStream
implements QuicStream {
    protected static long waitForNextFrameTimeout = Long.MAX_VALUE;
    protected static final float receiverMaxDataIncrementFactor = 0.1f;
    private Object addMonitor = new Object();
    protected final Version quicVersion;
    protected final int streamId;
    protected final QuicConnectionImpl connection;
    protected final FlowControl flowController;
    protected final Logger log;
    private final StreamInputStream inputStream;
    private final StreamOutputStream outputStream;
    private volatile boolean aborted;
    private volatile Thread blocking;
    private long receiverFlowControlLimit;
    private long lastCommunicatedMaxData;
    private final long receiverMaxDataIncrement;
    private volatile int lastOffset = -1;
    private int sendBufferSize = 51200;

    public QuicStreamImpl(int streamId, QuicConnectionImpl connection, FlowControl flowController) {
        this(Version.getDefault(), streamId, connection, flowController, new NullLogger());
    }

    public QuicStreamImpl(int streamId, QuicConnectionImpl connection, FlowControl flowController, Logger log) {
        this(Version.getDefault(), streamId, connection, flowController, log);
    }

    public QuicStreamImpl(Version quicVersion, int streamId, QuicConnectionImpl connection, FlowControl flowController, Logger log) {
        this(quicVersion, streamId, connection, flowController, log, null);
    }

    QuicStreamImpl(Version quicVersion, int streamId, QuicConnectionImpl connection, FlowControl flowController, Logger log, Integer sendBufferSize) {
        this.quicVersion = quicVersion;
        this.streamId = streamId;
        this.connection = connection;
        this.flowController = flowController;
        if (sendBufferSize != null && sendBufferSize > 0) {
            this.sendBufferSize = sendBufferSize;
        }
        this.log = log;
        this.inputStream = new StreamInputStream();
        this.outputStream = this.createStreamOutputStream();
        flowController.streamOpened(this);
        this.lastCommunicatedMaxData = this.receiverFlowControlLimit = connection.getInitialMaxStreamData();
        this.receiverMaxDataIncrement = (long)((float)this.receiverFlowControlLimit * 0.1f);
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(StreamFrame frame) {
        Object object = this.addMonitor;
        synchronized (object) {
            super.add(frame);
            if (frame.isFinal()) {
                this.lastOffset = frame.getUpToOffset();
            }
            this.addMonitor.notifyAll();
        }
    }

    @Override
    protected boolean isStreamEnd(int offset) {
        return this.lastOffset >= 0 && offset >= this.lastOffset;
    }

    @Override
    public int getStreamId() {
        return this.streamId;
    }

    @Override
    public boolean isUnidirectional() {
        return (this.streamId & 2) == 2;
    }

    @Override
    public boolean isClientInitiatedBidirectional() {
        return (this.streamId & 3) == 0;
    }

    @Override
    public boolean isServerInitiatedBidirectional() {
        return (this.streamId & 3) == 1;
    }

    @Override
    public void closeInput(int applicationProtocolErrorCode) {
        this.inputStream.stopInput(applicationProtocolErrorCode);
    }

    @Override
    public void resetStream(int errorCode) {
        this.outputStream.reset(errorCode);
    }

    public String toString() {
        return "Stream " + this.streamId;
    }

    protected StreamOutputStream createStreamOutputStream() {
        return new StreamOutputStream();
    }

    void terminateStream(int errorCode, long finalSize) {
        this.inputStream.terminate(errorCode, finalSize);
    }

    protected void resetOutputStream() {
        this.outputStream.restart();
    }

    void abort() {
        this.aborted = true;
        Thread readerBlocking = this.blocking;
        if (readerBlocking != null) {
            readerBlocking.interrupt();
        }
    }

    protected class StreamOutputStream
    extends OutputStream
    implements FlowControlUpdateListener {
        private static final int MIN_FRAME_SIZE = 20;
        private final ByteBuffer END_OF_STREAM_MARKER = ByteBuffer.allocate(0);
        private final Object lock = new Object();
        private Queue<ByteBuffer> sendQueue = new ConcurrentLinkedDeque<ByteBuffer>();
        private final int maxBufferSize;
        private final AtomicInteger bufferedBytes;
        private final ReentrantLock bufferLock;
        private final Condition notFull;
        private int currentOffset;
        private boolean closed;
        private volatile boolean sendRequestQueued;
        private volatile boolean reset;
        private volatile int resetErrorCode;

        StreamOutputStream() {
            this.maxBufferSize = QuicStreamImpl.this.sendBufferSize;
            this.bufferedBytes = new AtomicInteger();
            this.bufferLock = new ReentrantLock();
            this.notFull = this.bufferLock.newCondition();
            QuicStreamImpl.this.flowController.register(QuicStreamImpl.this, this);
        }

        @Override
        public void write(byte[] data) throws IOException {
            this.write(data, 0, data.length);
        }

        /*
         * Exception decompiling
         */
        @Override
        public void write(byte[] data, int off, int len) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void write(int dataByte) throws IOException {
            byte[] data = new byte[]{(byte)dataByte};
            this.write(data, 0, 1);
        }

        @Override
        public void flush() throws IOException {
            this.checkState();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (!this.closed && !this.reset) {
                this.sendQueue.add(this.END_OF_STREAM_MARKER);
                this.closed = true;
                Object object = this.lock;
                synchronized (object) {
                    if (!this.sendRequestQueued) {
                        this.sendRequestQueued = true;
                        QuicStreamImpl.this.connection.send(this::sendFrame, 20, this.getEncryptionLevel(), this::retransmitStreamFrame, true);
                    }
                }
            }
        }

        private void checkState() throws IOException {
            if (this.closed || this.reset) {
                throw new IOException("output stream " + (this.closed ? "already closed" : "is reset"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        QuicFrame sendFrame(int maxFrameSize) {
            if (this.reset) {
                return null;
            }
            Object object = this.lock;
            synchronized (object) {
                this.sendRequestQueued = false;
            }
            if (!this.sendQueue.isEmpty()) {
                int flowControlLimit = (int)QuicStreamImpl.this.flowController.getFlowControlLimit(QuicStreamImpl.this);
                assert (flowControlLimit >= this.currentOffset);
                int maxBytesToSend = this.bufferedBytes.get();
                if (flowControlLimit > this.currentOffset || maxBytesToSend == 0) {
                    int nrOfBytes = 0;
                    StreamFrame dummy = new StreamFrame(QuicStreamImpl.this.quicVersion, QuicStreamImpl.this.streamId, this.currentOffset, new byte[0], false);
                    maxBytesToSend = Integer.min(maxBytesToSend, maxFrameSize - dummy.getBytes().length - 1);
                    int maxAllowedByFlowControl = (int)(QuicStreamImpl.this.flowController.increaseFlowControlLimit(QuicStreamImpl.this, this.currentOffset + maxBytesToSend) - (long)this.currentOffset);
                    maxBytesToSend = Integer.min(maxAllowedByFlowControl, maxBytesToSend);
                    byte[] dataToSend = new byte[maxBytesToSend];
                    boolean finalFrame = false;
                    while (nrOfBytes < maxBytesToSend && !this.sendQueue.isEmpty()) {
                        ByteBuffer buffer = this.sendQueue.peek();
                        int position = nrOfBytes;
                        if (buffer.remaining() <= maxBytesToSend - nrOfBytes) {
                            nrOfBytes += buffer.remaining();
                            buffer.get(dataToSend, position, buffer.remaining());
                            this.sendQueue.poll();
                            continue;
                        }
                        buffer.get(dataToSend, position, maxBytesToSend - nrOfBytes);
                        nrOfBytes = maxBytesToSend;
                    }
                    if (!this.sendQueue.isEmpty() && this.sendQueue.peek() == this.END_OF_STREAM_MARKER) {
                        finalFrame = true;
                        this.sendQueue.poll();
                    }
                    if (nrOfBytes == 0 && !finalFrame) {
                        return null;
                    }
                    this.bufferedBytes.getAndAdd(-1 * nrOfBytes);
                    this.bufferLock.lock();
                    try {
                        this.notFull.signal();
                    }
                    finally {
                        this.bufferLock.unlock();
                    }
                    if (nrOfBytes < maxBytesToSend) {
                        dataToSend = Arrays.copyOfRange(dataToSend, 0, nrOfBytes);
                    }
                    StreamFrame streamFrame = new StreamFrame(QuicStreamImpl.this.quicVersion, QuicStreamImpl.this.streamId, this.currentOffset, dataToSend, finalFrame);
                    this.currentOffset += nrOfBytes;
                    if (!this.sendQueue.isEmpty()) {
                        Object object2 = this.lock;
                        synchronized (object2) {
                            this.sendRequestQueued = true;
                        }
                        QuicStreamImpl.this.connection.send(this::sendFrame, 20, this.getEncryptionLevel(), this::retransmitStreamFrame, true);
                    }
                    if (streamFrame.isFinal()) {
                        QuicStreamImpl.this.flowController.unregister(QuicStreamImpl.this);
                        QuicStreamImpl.this.flowController.streamClosed(QuicStreamImpl.this);
                    }
                    return streamFrame;
                }
                QuicStreamImpl.this.log.info("Stream " + QuicStreamImpl.this.streamId + " is blocked by flow control at " + flowControlLimit + " (note to self: should send DATA_BLOCKED or STREAM_DATA_BLOCKED ;-))");
            }
            return null;
        }

        @Override
        public void streamNotBlocked(int streamId) {
            QuicStreamImpl.this.connection.send(this::sendFrame, 20, this.getEncryptionLevel(), this::retransmitStreamFrame, false);
        }

        private void retransmitStreamFrame(QuicFrame frame) {
            assert (frame instanceof StreamFrame);
            if (!this.reset) {
                QuicStreamImpl.this.connection.send(frame, this::retransmitStreamFrame, true);
                QuicStreamImpl.this.log.recovery("Retransmitted lost stream frame " + frame);
            }
        }

        protected EncryptionLevel getEncryptionLevel() {
            return EncryptionLevel.App;
        }

        private void restart() {
            this.currentOffset = 0;
            this.sendQueue.clear();
            this.sendRequestQueued = false;
        }

        protected void reset(int errorCode) {
            if (!this.closed && !this.reset) {
                this.reset = true;
                this.resetErrorCode = errorCode;
                QuicStreamImpl.this.connection.send(this::createResetFrame, ResetStreamFrame.getMaximumFrameSize(QuicStreamImpl.this.streamId, errorCode), EncryptionLevel.App, this::retransmitResetFrame, true);
                this.bufferLock.lock();
                try {
                    this.notFull.signal();
                }
                finally {
                    this.bufferLock.unlock();
                }
            }
        }

        private QuicFrame createResetFrame(int maxFrameSize) {
            assert (this.reset);
            return new ResetStreamFrame(QuicStreamImpl.this.streamId, this.resetErrorCode, this.currentOffset);
        }

        private void retransmitResetFrame(QuicFrame frame) {
            assert (frame instanceof ResetStreamFrame);
            QuicStreamImpl.this.connection.send(frame, this::retransmitResetFrame, true);
        }
    }

    protected class StreamInputStream
    extends InputStream {
        private volatile boolean closed;
        private volatile boolean reset;

        protected StreamInputStream() {
        }

        @Override
        public int available() throws IOException {
            return Integer.max(0, QuicStreamImpl.this.bytesAvailable());
        }

        @Override
        public int read() throws IOException {
            byte[] data = new byte[1];
            int bytesRead = this.read(data, 0, 1);
            if (bytesRead == 1) {
                return data[0] & 0xFF;
            }
            if (bytesRead < 0) {
                return -1;
            }
            throw new RuntimeException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read(byte[] buffer, int offset, int len) throws IOException {
            Instant readAttemptStarted = Instant.now();
            long waitPeriod = waitForNextFrameTimeout;
            while (true) {
                if (QuicStreamImpl.this.aborted || this.closed || this.reset) {
                    String string;
                    if (QuicStreamImpl.this.aborted) {
                        string = "Connection closed";
                        throw new IOException(string);
                    }
                    if (this.closed) {
                        string = "Stream closed";
                        throw new IOException(string);
                    }
                    string = "Stream reset by peer";
                    throw new IOException(string);
                }
                Object object = QuicStreamImpl.this.addMonitor;
                synchronized (object) {
                    try {
                        QuicStreamImpl.this.blocking = Thread.currentThread();
                        int bytesRead = QuicStreamImpl.this.read(ByteBuffer.wrap(buffer, offset, len));
                        if (bytesRead > 0) {
                            this.updateAllowedFlowControl(bytesRead);
                            int n = bytesRead;
                            return n;
                        }
                        if (bytesRead < 0) {
                            int n = -1;
                            return n;
                        }
                        try {
                            QuicStreamImpl.this.addMonitor.wait(waitPeriod);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    finally {
                        QuicStreamImpl.this.blocking = null;
                    }
                    if (QuicStreamImpl.this.bytesAvailable() > 0) continue;
                }
                long waited = Duration.between(readAttemptStarted, Instant.now()).toMillis();
                if (waited > waitForNextFrameTimeout) {
                    throw new SocketTimeoutException("Read timeout on stream " + QuicStreamImpl.this.streamId + "; read up to " + QuicStreamImpl.this.readOffset());
                }
                waitPeriod = Long.max(1L, waitForNextFrameTimeout - waited);
            }
        }

        @Override
        public void close() throws IOException {
            this.stopInput(0);
        }

        private void stopInput(int errorCode) {
            if (!QuicStreamImpl.this.allDataReceived()) {
                QuicStreamImpl.this.connection.send(new StopSendingFrame(QuicStreamImpl.this.quicVersion, QuicStreamImpl.this.streamId, errorCode), this::retransmitStopInput);
            }
            this.closed = true;
            Thread blockingReader = QuicStreamImpl.this.blocking;
            if (blockingReader != null) {
                blockingReader.interrupt();
            }
        }

        private void retransmitStopInput(QuicFrame lostFrame) {
            assert (lostFrame instanceof StopSendingFrame);
            if (!QuicStreamImpl.this.allDataReceived()) {
                QuicStreamImpl.this.connection.send(lostFrame, this::retransmitStopInput);
            }
        }

        private void updateAllowedFlowControl(int bytesRead) {
            QuicStreamImpl.this.receiverFlowControlLimit += (long)bytesRead;
            QuicStreamImpl.this.connection.updateConnectionFlowControl(bytesRead);
            if (QuicStreamImpl.this.receiverFlowControlLimit - QuicStreamImpl.this.lastCommunicatedMaxData > QuicStreamImpl.this.receiverMaxDataIncrement) {
                QuicStreamImpl.this.connection.send(new MaxStreamDataFrame(QuicStreamImpl.this.streamId, QuicStreamImpl.this.receiverFlowControlLimit), this::retransmitMaxData);
                QuicStreamImpl.this.lastCommunicatedMaxData = QuicStreamImpl.this.receiverFlowControlLimit;
            }
        }

        private void retransmitMaxData(QuicFrame lostFrame) {
            QuicStreamImpl.this.connection.send(new MaxStreamDataFrame(QuicStreamImpl.this.streamId, QuicStreamImpl.this.receiverFlowControlLimit), this::retransmitMaxData);
            QuicStreamImpl.this.log.recovery("Retransmitted max stream data, because lost frame " + lostFrame);
        }

        void terminate(int errorCode, long finalSize) {
            if (!(QuicStreamImpl.this.aborted || this.closed || this.reset)) {
                this.reset = true;
                Thread blockingReader = QuicStreamImpl.this.blocking;
                if (blockingReader != null) {
                    blockingReader.interrupt();
                }
            }
        }
    }
}

