/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.stream;

import java.io.IOException;
import java.util.Arrays;
import net.luminis.quic.EncryptionLevel;
import net.luminis.quic.QuicClientConnectionImpl;
import net.luminis.quic.Version;
import net.luminis.quic.log.Logger;
import net.luminis.quic.stream.FlowControl;
import net.luminis.quic.stream.QuicStreamImpl;

public class EarlyDataStream
extends QuicStreamImpl {
    private volatile boolean sendingEarlyData = true;
    private boolean earlyDataIsFinalInStream;
    private byte[] earlyData = new byte[0];
    private byte[] remainingData = new byte[0];
    private boolean writingEarlyData = true;

    public EarlyDataStream(Version quicVersion, int streamId, QuicClientConnectionImpl connection, FlowControl flowController, Logger log) {
        super(quicVersion, streamId, connection, flowController, log);
    }

    public void writeEarlyData(byte[] earlyData, boolean fin, long earlyDataSizeLeft) throws IOException {
        this.earlyData = earlyData;
        this.earlyDataIsFinalInStream = fin;
        long flowControlLimit = this.flowController.getFlowControlLimit(this);
        int earlyDataLength = (int)Long.min(earlyData.length, Long.min(earlyDataSizeLeft, flowControlLimit));
        if (earlyDataLength > 0) {
            this.log.info(String.format("Sending %d bytes of early data on %s", earlyDataLength, this));
        } else {
            this.log.error("Sending no early data because: fc limit is " + flowControlLimit + "; early data size left is " + earlyDataSizeLeft + " and early data length is " + earlyData.length);
        }
        this.getOutputStream().write(earlyData, 0, earlyDataLength);
        if (earlyDataLength == earlyData.length && this.earlyDataIsFinalInStream) {
            this.getOutputStream().close();
        }
        this.sendingEarlyData = false;
        this.remainingData = Arrays.copyOfRange(earlyData, earlyDataLength, earlyData.length);
    }

    public void writeRemaining(boolean earlyDataWasAccepted) throws IOException {
        this.writingEarlyData = false;
        if (earlyDataWasAccepted) {
            if (this.remainingData.length > 0) {
                this.getOutputStream().write(this.remainingData);
                this.getOutputStream().close();
            }
        } else {
            this.resetOutputStream();
            this.getOutputStream().write(this.earlyData);
            if (this.earlyDataIsFinalInStream) {
                this.getOutputStream().close();
            }
        }
    }

    @Override
    protected QuicStreamImpl.StreamOutputStream createStreamOutputStream() {
        return new EarlyDataStreamOutputStream();
    }

    protected class EarlyDataStreamOutputStream
    extends QuicStreamImpl.StreamOutputStream {
        protected EarlyDataStreamOutputStream() {
            super(EarlyDataStream.this);
        }

        @Override
        protected EncryptionLevel getEncryptionLevel() {
            return EarlyDataStream.this.writingEarlyData ? EncryptionLevel.ZeroRTT : EncryptionLevel.App;
        }
    }
}

