/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.server.h09;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.luminis.quic.QuicConnection;
import net.luminis.quic.QuicConstants;
import net.luminis.quic.QuicStream;
import net.luminis.quic.io.LimitExceededException;
import net.luminis.quic.io.LimitedInputStream;
import net.luminis.quic.run.KwikVersion;
import net.luminis.quic.server.ApplicationProtocolConnection;

public class Http09Connection
extends ApplicationProtocolConnection
implements Consumer<QuicStream> {
    public static final int MAX_REQUEST_SIZE = 4096;
    private static AtomicInteger threadCount = new AtomicInteger();
    private final QuicConnection connection;
    private final File wwwDir;

    public Http09Connection(QuicConnection quicConnection, File wwwDir) {
        this.wwwDir = wwwDir;
        this.connection = quicConnection;
        this.connection.setPeerInitiatedStreamCallback(this);
    }

    @Override
    public void accept(QuicStream quicStream) {
        Thread thread = new Thread(() -> this.handleRequest(quicStream));
        thread.setName("http-" + threadCount.getAndIncrement());
        thread.start();
    }

    void handleRequest(QuicStream quicStream) {
        try {
            String fileName = this.extractPathFromRequest(quicStream.getInputStream());
            if (fileName != null) {
                File file = this.getFileInWwwDir(fileName);
                OutputStream outputStream = quicStream.getOutputStream();
                if (file != null && file.exists() && file.isFile() && file.canRead()) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    fileInputStream.transferTo(outputStream);
                    fileInputStream.close();
                } else if (fileName.equals("version") || fileName.equals("version.txt")) {
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
                    outputStreamWriter.write("Kwik version/build number: " + KwikVersion.getVersion() + "\n");
                    outputStreamWriter.close();
                } else {
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
                    outputStreamWriter.write("404: file '" + fileName + "' not found\n");
                    outputStreamWriter.close();
                }
                outputStream.close();
            } else {
                System.out.println("Error: cannot extract file name");
            }
        }
        catch (LimitExceededException requestToLarge) {
            this.connection.close(QuicConstants.TransportErrorCode.APPLICATION_ERROR, "Request too large");
        }
        catch (IOException e) {
            this.connection.close(QuicConstants.TransportErrorCode.APPLICATION_ERROR, e.getMessage());
            e.printStackTrace();
        }
    }

    private File getFileInWwwDir(String fileName) throws IOException {
        String requestedFilePath = new File(this.wwwDir, fileName).getCanonicalPath();
        if (requestedFilePath.startsWith(this.wwwDir.getCanonicalPath())) {
            return new File(requestedFilePath);
        }
        return null;
    }

    String extractPathFromRequest(InputStream input) throws IOException {
        BufferedReader inputReader = new BufferedReader(new InputStreamReader(new LimitedInputStream(input, 4096L)));
        String line = inputReader.readLine();
        Matcher matcher = Pattern.compile("GET\\s+/?(\\S+)").matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }
}

