/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.server;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.luminis.quic.packet.InitialPacket;
import net.luminis.quic.server.ServerConnectionImpl;
import net.luminis.quic.server.ServerConnectionProxy;
import net.luminis.tls.util.ByteUtils;

public class ServerConnectionThread
implements ServerConnectionProxy {
    private final ServerConnectionImpl serverConnection;
    private final BlockingQueue<ReceivedDatagram> queue;
    private final Thread connectionReceiverThread;
    private final InitialPacket firstInitialPacket;
    private final Instant firstPacketReceived;
    private final ByteBuffer firstDatagram;

    public ServerConnectionThread(ServerConnectionImpl serverConnection, InitialPacket firstInitialPacket, Instant firstPacketReceived, ByteBuffer firstDatagram) {
        this.serverConnection = serverConnection;
        this.firstInitialPacket = firstInitialPacket;
        this.firstPacketReceived = firstPacketReceived;
        this.firstDatagram = firstDatagram;
        this.queue = new LinkedBlockingQueue<ReceivedDatagram>();
        String threadId = "receiver-" + ByteUtils.bytesToHex(serverConnection.getOriginalDestinationConnectionId());
        this.connectionReceiverThread = new Thread(this::process, threadId);
        this.connectionReceiverThread.start();
    }

    @Override
    public byte[] getOriginalDestinationConnectionId() {
        return this.serverConnection.getOriginalDestinationConnectionId();
    }

    @Override
    public void parsePackets(int datagramNumber, Instant timeReceived, ByteBuffer data) {
        this.queue.add(new ReceivedDatagram(datagramNumber, timeReceived, data));
    }

    @Override
    public boolean isClosed() {
        return this.serverConnection.isClosed();
    }

    @Override
    public void terminate() {
        this.connectionReceiverThread.interrupt();
    }

    private void process() {
        try {
            if (this.firstInitialPacket != null) {
                this.serverConnection.parseAndProcessPackets(0, this.firstPacketReceived, this.firstDatagram, this.firstInitialPacket);
            }
            while (true) {
                ReceivedDatagram datagram = this.queue.take();
                this.serverConnection.parseAndProcessPackets(datagram.datagramNumber, datagram.timeReceived, datagram.data, null);
            }
        }
        catch (InterruptedException datagram) {
        }
        catch (Exception error) {
            this.serverConnection.abortConnection(error);
        }
    }

    static class ReceivedDatagram {
        final int datagramNumber;
        final Instant timeReceived;
        final ByteBuffer data;

        public ReceivedDatagram(int datagramNumber, Instant timeReceived, ByteBuffer data) {
            this.datagramNumber = datagramNumber;
            this.timeReceived = timeReceived;
            this.data = data;
        }
    }
}

