/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.server;

import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.security.SecureRandom;
import java.util.function.Consumer;
import net.luminis.quic.Version;
import net.luminis.quic.log.Logger;
import net.luminis.quic.server.ApplicationProtocolRegistry;
import net.luminis.quic.server.ServerConnectionImpl;
import net.luminis.tls.handshake.TlsServerEngineFactory;

public class ServerConnectionFactory {
    private final int connectionIdLength;
    private final Logger log;
    private final TlsServerEngineFactory tlsServerEngineFactory;
    private final ApplicationProtocolRegistry applicationProtocolRegistry;
    private final DatagramSocket serverSocket;
    private final int initalRtt;
    private final SecureRandom randomGenerator;
    private final Consumer<byte[]> closeCallback;
    private final boolean requireRetry;

    public ServerConnectionFactory(int connectionIdLength, DatagramSocket serverSocket, TlsServerEngineFactory tlsServerEngineFactory, boolean requireRetry, ApplicationProtocolRegistry applicationProtocolRegistry, int initalRtt, Consumer<byte[]> closeCallback, Logger log) {
        if (connectionIdLength > 20 || connectionIdLength < 0) {
            throw new IllegalArgumentException();
        }
        this.tlsServerEngineFactory = tlsServerEngineFactory;
        this.requireRetry = requireRetry;
        this.applicationProtocolRegistry = applicationProtocolRegistry;
        this.connectionIdLength = connectionIdLength;
        this.closeCallback = closeCallback;
        this.log = log;
        this.serverSocket = serverSocket;
        this.initalRtt = initalRtt;
        this.randomGenerator = new SecureRandom();
    }

    public ServerConnectionImpl createNewConnection(Version version, InetSocketAddress clientAddress, byte[] originalScid, byte[] originalDcid) {
        byte[] connectionId = this.generateNewConnectionId();
        byte[] dcid = originalScid;
        return new ServerConnectionImpl(version, this.serverSocket, clientAddress, connectionId, dcid, originalDcid, this.tlsServerEngineFactory, this.requireRetry, this.applicationProtocolRegistry, this.initalRtt, this.closeCallback, this.log);
    }

    private byte[] generateNewConnectionId() {
        byte[] connectionId = new byte[this.connectionIdLength];
        this.randomGenerator.nextBytes(connectionId);
        return connectionId;
    }
}

