/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.luminis.quic.QuicConnection;
import net.luminis.quic.server.ApplicationProtocolConnection;
import net.luminis.quic.server.ApplicationProtocolConnectionFactory;

public class ApplicationProtocolRegistry {
    Map<String, ApplicationProtocolConnectionFactory> registeredFactories = new HashMap<String, ApplicationProtocolConnectionFactory>();

    Optional<String> selectSupportedApplicationProtocol(List<String> protocols) {
        HashSet<String> intersection = new HashSet<String>(this.registeredFactories.keySet());
        intersection.retainAll(protocols);
        return intersection.stream().findFirst();
    }

    ApplicationProtocolConnection startApplicationProtocolConnection(String protocol, QuicConnection quicConnection) {
        return this.registeredFactories.get(protocol).createConnection(protocol, quicConnection);
    }

    void registerApplicationProtocol(String protocol, ApplicationProtocolConnectionFactory factory) {
        this.registeredFactories.put(protocol, factory);
    }

    Set<String> getRegisteredApplicationProtocols() {
        return this.registeredFactories.keySet();
    }
}

