/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.send;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.luminis.quic.frame.PingFrame;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.send.SendRequest;

public class SendRequestQueue {
    private List<SendRequest> requestQueue = Collections.synchronizedList(new ArrayList());
    private List<List<QuicFrame>> probeQueue = Collections.synchronizedList(new ArrayList());
    private final Object ackLock = new Object();
    private Instant nextAckTime;
    private volatile boolean cleared;

    public void addRequest(QuicFrame fixedFrame, Consumer<QuicFrame> lostCallback) {
        this.requestQueue.add(new SendRequest(fixedFrame.getBytes().length, actualMaxSize -> fixedFrame, lostCallback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAckRequest() {
        Object object = this.ackLock;
        synchronized (object) {
            this.nextAckTime = Instant.now();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAckRequest(int delay) {
        Instant requestedAckTime = Instant.now().plusMillis(delay);
        Object object = this.ackLock;
        synchronized (object) {
            if (this.nextAckTime == null || requestedAckTime.isBefore(this.nextAckTime)) {
                this.nextAckTime = requestedAckTime;
            }
        }
    }

    public void addProbeRequest() {
        this.probeQueue.add(Collections.emptyList());
    }

    public void addProbeRequest(List<QuicFrame> frames) {
        this.probeQueue.add(frames);
    }

    public boolean hasProbe() {
        return !this.probeQueue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProbeWithData() {
        List<List<QuicFrame>> list = this.probeQueue;
        synchronized (list) {
            return !this.probeQueue.isEmpty() && !this.probeQueue.get(0).isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QuicFrame> getProbe() {
        List<List<QuicFrame>> list = this.probeQueue;
        synchronized (list) {
            if (this.hasProbe()) {
                return this.probeQueue.remove(0);
            }
            return List.of(new PingFrame());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mustSendAck() {
        Instant now = Instant.now();
        Object object = this.ackLock;
        synchronized (object) {
            return this.nextAckTime != null && (now.isAfter(this.nextAckTime) || Duration.between(now, this.nextAckTime).toMillis() < 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mustAndWillSendAck() {
        Instant now = Instant.now();
        Object object = this.ackLock;
        synchronized (object) {
            boolean must;
            boolean bl = must = this.nextAckTime != null && (now.isAfter(this.nextAckTime) || Duration.between(now, this.nextAckTime).toMillis() < 1L);
            if (must) {
                this.nextAckTime = null;
            }
            return must;
        }
    }

    public Instant getAck() {
        Object object = this.ackLock;
        synchronized (object) {
            Instant instant;
            try {
                instant = this.nextAckTime;
                this.nextAckTime = null;
            }
            catch (Throwable throwable) {
                this.nextAckTime = null;
                throw throwable;
            }
            return instant;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instant nextDelayedSend() {
        Object object = this.ackLock;
        synchronized (object) {
            return this.nextAckTime;
        }
    }

    public void addRequest(Function<Integer, QuicFrame> frameSupplier, int estimatedSize, Consumer<QuicFrame> lostCallback) {
        this.requestQueue.add(new SendRequest(estimatedSize, frameSupplier, lostCallback));
    }

    public boolean hasRequests() {
        return !this.requestQueue.isEmpty();
    }

    public Optional<SendRequest> next(int maxFrameLength) {
        if (maxFrameLength < 1) {
            return Optional.empty();
        }
        for (int i = 0; i < this.requestQueue.size(); ++i) {
            try {
                if (this.requestQueue.get(i).getEstimatedSize() > maxFrameLength) continue;
                return Optional.of(this.requestQueue.remove(i));
            }
            catch (IndexOutOfBoundsException indexError) {
                if (this.cleared) {
                    return Optional.empty();
                }
                throw indexError;
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.cleared = true;
        this.requestQueue.clear();
        this.probeQueue.clear();
        Object object = this.ackLock;
        synchronized (object) {
            this.nextAckTime = null;
        }
    }
}

