/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.run;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import net.luminis.quic.QuicClientConnectionImpl;
import net.luminis.quic.QuicStream;
import net.luminis.quic.Version;
import net.luminis.quic.log.SysOutLogger;

public class Sample {
    public static void main(String[] args) throws Exception {
        SysOutLogger log = new SysOutLogger();
        log.logPackets(true);
        log.logInfo(true);
        QuicClientConnectionImpl.Builder builder = QuicClientConnectionImpl.newBuilder();
        QuicClientConnectionImpl connection = builder.version(Version.IETF_draft_32).uri(new URI(args[0])).build();
        connection.connect(10000, "hq-32");
        QuicStream stream = connection.createStream(true);
        BufferedOutputStream outputStream = new BufferedOutputStream(stream.getOutputStream());
        outputStream.write("GET / \r\n".getBytes(StandardCharsets.UTF_8));
        outputStream.flush();
        long transferred = stream.getInputStream().transferTo(new FileOutputStream("kwik_client_output"));
        connection.close();
        System.out.println("Received " + transferred + " bytes.");
    }
}

