/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.run;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import net.luminis.quic.QuicClientConnection;
import net.luminis.quic.QuicClientConnectionImpl;
import net.luminis.quic.QuicConnection;
import net.luminis.quic.QuicSessionTicket;
import net.luminis.quic.Version;
import net.luminis.quic.VersionNegotiationFailure;
import net.luminis.quic.client.h09.Http09Client;
import net.luminis.quic.log.FileLogger;
import net.luminis.quic.log.SysOutLogger;
import net.luminis.quic.run.InteractiveShell;
import net.luminis.quic.run.KwikVersion;
import net.luminis.tls.NewSessionTicket;
import net.luminis.tls.TlsConstants;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class KwikCli {
    private static Options cmdLineOptions;
    private static String DEFAULT_LOG_ARGS;

    /*
     * Unable to fully structure code
     */
    public static void main(String[] rawArgs) throws ParseException {
        KwikCli.cmdLineOptions = new Options();
        KwikCli.cmdLineOptions.addOption("l", "log", true, "logging options: [pdrcsiRSD]: (p)ackets received/sent, (d)ecrypted bytes, (r)ecovery, (c)ongestion control, (s)tats, (i)nfo, (w)arning, (R)aw bytes, (S)ecrets, (D)ebug;  default is \"" + KwikCli.DEFAULT_LOG_ARGS + "\", use (n)one to disable");
        KwikCli.cmdLineOptions.addOption("h", "help", false, "show help");
        KwikCli.cmdLineOptions.addOption("29", "use Quic version IETF_draft_29");
        KwikCli.cmdLineOptions.addOption("30", "use Quic version IETF_draft_30");
        KwikCli.cmdLineOptions.addOption("31", "use Quic version IETF_draft_31");
        KwikCli.cmdLineOptions.addOption("32", "use Quic version IETF_draft_32");
        KwikCli.cmdLineOptions.addOption("v1", "use Quic version 1");
        KwikCli.cmdLineOptions.addOption(null, "reservedVersion", false, "use reserved version to trigger version negotiation");
        KwikCli.cmdLineOptions.addOption("A", "alpn", true, "set alpn (default is hq-xx)");
        KwikCli.cmdLineOptions.addOption("R", "resumption key", true, "session ticket file");
        KwikCli.cmdLineOptions.addOption("c", "connectionTimeout", true, "connection timeout in seconds");
        KwikCli.cmdLineOptions.addOption("i", "interactive", false, "start interactive shell");
        KwikCli.cmdLineOptions.addOption("k", "keepAlive", true, "connection keep alive time in seconds");
        KwikCli.cmdLineOptions.addOption("L", "logFile", true, "file to write log message to");
        KwikCli.cmdLineOptions.addOption("O", "output", true, "write server response to file");
        KwikCli.cmdLineOptions.addOption("H", "http", true, "send HTTP GET request, arg is path, e.g. '/index.html'");
        KwikCli.cmdLineOptions.addOption("S", "storeTickets", true, "basename of file to store new session tickets");
        KwikCli.cmdLineOptions.addOption("T", "relativeTime", false, "log with time (in seconds) since first packet");
        KwikCli.cmdLineOptions.addOption("Z", "use0RTT", false, "use 0-RTT if possible (requires -H)");
        KwikCli.cmdLineOptions.addOption(null, "secrets", true, "write secrets to file (Wireshark format)");
        KwikCli.cmdLineOptions.addOption("v", "version", false, "show Kwik version");
        KwikCli.cmdLineOptions.addOption(null, "initialRtt", true, "custom initial RTT value (default is 500)");
        KwikCli.cmdLineOptions.addOption(null, "chacha20", false, "use ChaCha20 as only cipher suite");
        KwikCli.cmdLineOptions.addOption(null, "noCertificateCheck", false, "do not check server certificate");
        KwikCli.cmdLineOptions.addOption(null, "saveServerCertificates", true, "store server certificates in given file");
        KwikCli.cmdLineOptions.addOption(null, "quantumReadinessTest", true, "add number of random bytes to client hello");
        KwikCli.cmdLineOptions.addOption(null, "clientCertificate", true, "certificate (file) for client authentication");
        KwikCli.cmdLineOptions.addOption(null, "clientKey", true, "private key (file) for client certificate");
        parser = new DefaultParser();
        cmd = null;
        try {
            cmd = parser.parse(KwikCli.cmdLineOptions, rawArgs);
        }
        catch (ParseException argError) {
            System.out.println("Invalid argument: " + argError.getMessage());
            KwikCli.usage();
            System.exit(1);
        }
        if (cmd.hasOption("v")) {
            System.out.println("Kwik build nr: " + KwikVersion.getVersion());
            System.exit(0);
        }
        if ((args = cmd.getArgList()).size() == 0) {
            KwikCli.usage();
            return;
        }
        builder = QuicClientConnectionImpl.newBuilder();
        httpRequestPath = null;
        if (args.size() == 1) {
            arg = args.get(0);
            try {
                if (arg.startsWith("http://") || arg.startsWith("https://")) {
                    try {
                        url = new URL(arg);
                        builder.uri(url.toURI());
                        if (url.getPath().isEmpty()) ** GOTO lbl114
                        httpRequestPath = url.getPath();
                    }
                    catch (MalformedURLException e) {
                        System.out.println("Cannot parse URL '" + arg + "'");
                        return;
                    }
                }
                if (arg.contains(":")) {
                    builder.uri(new URI("//" + arg));
                }
                if (arg.matches("\\d+")) {
                    System.out.println("Error: invalid hostname (did you forget to specify an option argument?).");
                    KwikCli.usage();
                    return;
                }
                builder.uri(new URI("//" + arg + ":443"));
            }
            catch (URISyntaxException invalidUri) {
                System.out.println("Cannot parse URI '" + arg + "'");
                return;
            }
        } else if (args.size() == 2) {
            try {
                builder.uri(new URI("//" + args.get(0) + ":" + args.get(1)));
            }
            catch (URISyntaxException invalidUri) {
                System.out.println("Cannot parse URI '" + args.stream().collect(Collectors.joining(":")) + "'");
                return;
            }
        } else if (args.size() > 2) {
            KwikCli.usage();
            return;
        }
lbl114:
        // 7 sources

        if (cmd.hasOption("chacha20")) {
            builder.cipherSuite(TlsConstants.CipherSuite.TLS_CHACHA20_POLY1305_SHA256);
        }
        if (cmd.hasOption("noCertificateCheck")) {
            builder.noServerCertificateCheck();
        }
        serverCertificatesFile = null;
        if (cmd.hasOption("saveServerCertificates")) {
            serverCertificatesFile = cmd.getOptionValue("saveServerCertificates");
        }
        logger = null;
        if (cmd.hasOption("L")) {
            logFilename = cmd.getOptionValue("L");
            try {
                logger = new FileLogger(new File(logFilename));
            }
            catch (IOException fileError) {
                System.err.println("Error: cannot open log file '" + logFilename + "'");
            }
        }
        if (logger == null) {
            logger = new SysOutLogger();
        }
        builder.logger(logger);
        logArg = KwikCli.DEFAULT_LOG_ARGS;
        if (cmd.hasOption('l')) {
            logArg = cmd.getOptionValue('l', logArg);
        }
        if (!logArg.contains("n")) {
            if (logArg.contains("R")) {
                logger.logRaw(true);
            }
            if (logArg.contains("r")) {
                logger.logRecovery(true);
            }
            if (logArg.contains("c")) {
                logger.logCongestionControl(true);
            }
            if (logArg.contains("d")) {
                logger.logDecrypted(true);
            }
            if (logArg.contains("S")) {
                logger.logSecrets(true);
            }
            if (logArg.contains("p")) {
                logger.logPackets(true);
            }
            if (logArg.contains("i")) {
                logger.logInfo(true);
            }
            if (logArg.contains("w")) {
                logger.logWarning(true);
            }
            if (logArg.contains("s")) {
                logger.logStats(true);
            }
            if (logArg.contains("D")) {
                logger.logDebug(true);
            }
        }
        quicVersion = Version.getDefault();
        if (cmd.hasOption("v1")) {
            quicVersion = Version.QUIC_version_1;
        } else if (cmd.hasOption("32")) {
            quicVersion = Version.IETF_draft_32;
        } else if (cmd.hasOption("31")) {
            quicVersion = Version.IETF_draft_31;
        } else if (cmd.hasOption("30")) {
            quicVersion = Version.IETF_draft_30;
        } else if (cmd.hasOption("29")) {
            quicVersion = Version.IETF_draft_29;
        }
        if (cmd.hasOption("reservedVersion")) {
            quicVersion = Version.reserved_1;
        }
        builder.version(quicVersion);
        httpVersion = KwikCli.loadHttp3ClientClass() != false ? HttpVersion.HTTP3 : HttpVersion.HTTP09;
        alpn = null;
        if (cmd.hasOption("A")) {
            alpn = cmd.getOptionValue("A", null);
            if (alpn == null) {
                KwikCli.usage();
                System.exit(1);
            }
        } else {
            alpn = quicVersion.equals((Object)Version.QUIC_version_1) != false ? (httpVersion == HttpVersion.HTTP3 ? "h3" : "hq-interop") : (httpVersion == HttpVersion.HTTP3 ? "h3-" : "hq-") + quicVersion.getDraftVersion();
        }
        connectionTimeout = 5;
        if (cmd.hasOption("c")) {
            try {
                connectionTimeout = Integer.parseInt(cmd.getOptionValue("c", "5"));
            }
            catch (NumberFormatException e) {
                KwikCli.usage();
                System.exit(1);
            }
        }
        keepAliveTime = 0;
        if (cmd.hasOption("k")) {
            try {
                keepAliveTime = Integer.parseInt(cmd.getOptionValue("k"));
            }
            catch (NumberFormatException e) {
                KwikCli.usage();
                System.exit(1);
            }
        }
        useZeroRtt = false;
        if (cmd.hasOption("Z")) {
            useZeroRtt = true;
        }
        if (cmd.hasOption("H")) {
            httpRequestPath = cmd.getOptionValue("H");
            if (httpRequestPath == null) {
                KwikCli.usage();
                System.exit(1);
            } else if (!httpRequestPath.startsWith("/")) {
                httpRequestPath = "/" + (String)httpRequestPath;
            }
        }
        if (useZeroRtt && httpRequestPath == null) {
            KwikCli.usage();
            System.exit(1);
        }
        outputFile = null;
        if (cmd.hasOption("O")) {
            outputFile = cmd.getOptionValue("O");
            if (outputFile == null) {
                KwikCli.usage();
                System.exit(1);
            }
            if (Files.exists(Paths.get(outputFile, new String[0]), new LinkOption[0]) && !Files.isWritable(Paths.get(outputFile, new String[0]))) {
                System.err.println("Output file '" + outputFile + "' is not writable.");
                System.exit(1);
            }
        }
        if (cmd.hasOption("secrets")) {
            secretsFile = cmd.getOptionValue("secrets");
            if (secretsFile == null) {
                KwikCli.usage();
                System.exit(1);
            }
            if (Files.exists(Paths.get(secretsFile, new String[0]), new LinkOption[0]) && !Files.isWritable(Paths.get(secretsFile, new String[0]))) {
                System.err.println("Secrets file '" + secretsFile + "' is not writable.");
                System.exit(1);
            }
            builder.secrets(Paths.get(secretsFile, new String[0]));
        }
        newSessionTicketsFilename = null;
        if (cmd.hasOption("S") && (newSessionTicketsFilename = cmd.getOptionValue("S")) == null) {
            KwikCli.usage();
            System.exit(1);
        }
        sessionTicket = null;
        if (cmd.hasOption("R")) {
            sessionTicketFile = null;
            sessionTicketFile = cmd.getOptionValue("R");
            if (sessionTicketFile == null) {
                KwikCli.usage();
                System.exit(1);
            }
            if (!Files.isReadable(Paths.get(sessionTicketFile, new String[0]))) {
                System.err.println("Session ticket file '" + sessionTicketFile + "' is not readable.");
                System.exit(1);
            }
            ticketData = new byte[]{};
            try {
                ticketData = Files.readAllBytes(Paths.get(sessionTicketFile, new String[0]));
                sessionTicket = QuicSessionTicket.deserialize(ticketData);
                builder.sessionTicket(sessionTicket);
            }
            catch (IOException e) {
                System.err.println("Error while reading session ticket file.");
            }
        }
        if (useZeroRtt && sessionTicket == null) {
            System.err.println("Using 0-RTT requires a session ticket");
            System.exit(1);
        }
        if (cmd.hasOption("clientCertificate") && cmd.hasOption("clientKey")) {
            try {
                builder.clientCertificate(KwikCli.readCertificate(cmd.getOptionValue("clientCertificate")));
                builder.clientCertificateKey(KwikCli.readKey(cmd.getOptionValue("clientKey")));
            }
            catch (Exception e) {
                System.err.println("Loading client certificate/key failed: " + e);
                System.exit(1);
            }
        } else if (cmd.hasOption("clientCertificate") || cmd.hasOption("clientKey")) {
            System.err.println("Options --clientCertificate and --clientKey should always be used together");
            System.exit(1);
        }
        if (cmd.hasOption("quantumReadinessTest")) {
            try {
                builder.quantumReadinessTest(Integer.parseInt(cmd.getOptionValue("quantumReadinessTest")));
            }
            catch (NumberFormatException e) {
                KwikCli.usage();
                System.exit(1);
            }
        }
        if (cmd.hasOption("T")) {
            logger.useRelativeTime(true);
        }
        interactiveMode = cmd.hasOption("i");
        if (cmd.hasOption("initialRtt")) {
            try {
                builder.initialRtt(Integer.parseInt(cmd.getOptionValue("initialRtt")));
            }
            catch (NumberFormatException e) {
                KwikCli.usage();
                System.exit(1);
            }
        }
        try {
            if (interactiveMode) {
                new InteractiveShell(builder, (String)alpn, httpVersion).start();
            } else {
                quicConnection = builder.build();
                if (keepAliveTime > 0) {
                    quicConnection.keepAlive(keepAliveTime);
                }
                if (httpRequestPath != null) {
                    try {
                        httpClient = KwikCli.createHttpClient(httpVersion, quicConnection, useZeroRtt);
                        serverAddress = quicConnection.getServerAddress();
                        request = HttpRequest.newBuilder().uri(new URI("https", null, serverAddress.getHostName(), serverAddress.getPort(), (String)httpRequestPath, null, null)).build();
                        if (outputFile != null) {
                            if (new File(outputFile).isDirectory()) {
                                outputFile = new File(outputFile, new File((String)httpRequestPath).getName()).getAbsolutePath();
                            }
                            httpClient.send(request, HttpResponse.BodyHandlers.ofFile(Paths.get(outputFile, new String[0])));
                        }
                        httpResponse = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException var24_42) {
                            // empty catch block
                        }
                        System.out.println("Server returns: \n" + httpResponse.body());
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println("HTTP request is interrupted");
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException();
                    }
                } else {
                    quicConnection.connect(connectionTimeout, (String)alpn, null, null);
                    if (keepAliveTime > 0) {
                        try {
                            Thread.sleep((keepAliveTime + 30) * 1000);
                        }
                        catch (InterruptedException var20_37) {
                            // empty catch block
                        }
                    }
                }
                if (serverCertificatesFile != null) {
                    KwikCli.storeServerCertificates(quicConnection, serverCertificatesFile);
                }
                if (newSessionTicketsFilename != null) {
                    KwikCli.storeNewSessionTickets(quicConnection, newSessionTicketsFilename);
                }
                quicConnection.close();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException var20_38) {
                    // empty catch block
                }
            }
            System.out.println("Terminating Kwik");
        }
        catch (IOException e) {
            System.out.println("Got IO error: " + e);
        }
        catch (VersionNegotiationFailure e) {
            System.out.println("Client and server could not agree on a compatible QUIC version.");
        }
        if (!interactiveMode && httpRequestPath == null && keepAliveTime == 0) {
            System.out.println("This was quick, huh? Next time, consider using --http09 or --keepAlive argument.");
        }
    }

    private static boolean loadHttp3ClientClass() {
        try {
            KwikCli.class.getClassLoader().loadClass("net.luminis.http3.Http3SingleConnectionClient");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static HttpClient createHttpClient(HttpVersion httpVersion, QuicClientConnection quicConnection, boolean useZeroRtt) {
        if (httpVersion == HttpVersion.HTTP3) {
            try {
                Class<?> http3ClientClass = KwikCli.class.getClassLoader().loadClass("net.luminis.http3.Http3SingleConnectionClient");
                Constructor<?> constructor = http3ClientClass.getConstructor(QuicConnection.class, Duration.class, Long.class);
                long maxReceiveBufferSize = 50000000L;
                Duration connectionTimeout = Duration.ofSeconds(60L);
                HttpClient http3Client = (HttpClient)constructor.newInstance(quicConnection, connectionTimeout, maxReceiveBufferSize);
                return http3Client;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return new Http09Client(quicConnection, useZeroRtt);
    }

    private static PrivateKey readKey(String clientKey) throws IOException, InvalidKeySpecException {
        String key = new String(Files.readAllBytes(Paths.get(clientKey, new String[0])), Charset.defaultCharset());
        if (key.contains("BEGIN PRIVATE KEY")) {
            return KwikCli.loadRSAKey(key);
        }
        if (key.contains("BEGIN EC PRIVATE KEY")) {
            throw new IllegalArgumentException("EC private key must be in DER format");
        }
        return KwikCli.loadECKey(Files.readAllBytes(Paths.get(clientKey, new String[0])));
    }

    private static PrivateKey loadRSAKey(String key) throws InvalidKeySpecException {
        String privateKeyPEM = key.replace("-----BEGIN PRIVATE KEY-----", "").replaceAll(System.lineSeparator(), "").replace("-----END PRIVATE KEY-----", "");
        byte[] encoded = Base64.getMimeDecoder().decode(privateKeyPEM);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Missing key algorithm RSA");
        }
    }

    private static PrivateKey loadECKey(byte[] pkcs8key) throws InvalidKeySpecException {
        try {
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(pkcs8key);
            KeyFactory factory = KeyFactory.getInstance("EC");
            PrivateKey privateKey = factory.generatePrivate(spec);
            return privateKey;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Missing ECDSA support");
        }
    }

    private static X509Certificate readCertificate(String certificateFile) throws IOException, CertificateException {
        String fileContent = new String(Files.readAllBytes(Paths.get(certificateFile, new String[0])), Charset.defaultCharset());
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        if (fileContent.startsWith("-----BEGIN CERTIFICATE-----")) {
            String encodedCertificate = fileContent.replace("-----BEGIN CERTIFICATE-----", "").replaceAll(System.lineSeparator(), "").replace("-----END CERTIFICATE-----", "");
            Certificate certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(Base64.getDecoder().decode(encodedCertificate)));
            return (X509Certificate)certificate;
        }
        throw new IllegalArgumentException("Invalid certificate file");
    }

    private static void storeServerCertificates(QuicClientConnection quicConnection, String serverCertificatesFile) throws IOException {
        List<X509Certificate> serverCertificateChain = quicConnection.getServerCertificateChain();
        if (!((String)serverCertificatesFile).endsWith(".pem")) {
            serverCertificatesFile = (String)serverCertificatesFile + ".pem";
        }
        PrintStream out = new PrintStream(new FileOutputStream(new File((String)serverCertificatesFile)));
        for (X509Certificate cert : serverCertificateChain) {
            out.println("-----BEGIN CERTIFICATE-----");
            try {
                out.print(new String(Base64.getMimeEncoder().encode(cert.getEncoded())));
            }
            catch (CertificateEncodingException e) {
                throw new IOException(e.getMessage());
            }
            out.println("\n-----END CERTIFICATE-----");
            out.println("\n");
        }
        out.close();
    }

    private static void storeNewSessionTickets(QuicClientConnection quicConnection, String baseFilename) {
        if (quicConnection.getNewSessionTickets().isEmpty()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (quicConnection.getNewSessionTickets().isEmpty()) {
                System.out.println("There are new new session tickets to store.");
            }
        }
        quicConnection.getNewSessionTickets().stream().forEach(ticket -> KwikCli.storeNewSessionTicket(ticket, baseFilename));
    }

    private static void storeNewSessionTicket(NewSessionTicket ticket, String baseFilename) {
        int i;
        int maxFiles = 100;
        File savedSessionTicket = new File(baseFilename + ".bin");
        for (i = 1; i <= maxFiles && savedSessionTicket.exists(); ++i) {
            savedSessionTicket = new File(baseFilename + i + ".bin");
        }
        if (i > maxFiles) {
            System.out.println("Cannot store ticket: too many files with base name '" + baseFilename + "' already exist.");
            return;
        }
        try {
            Files.write(savedSessionTicket.toPath(), ticket.serialize(), StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            System.err.println("Saving new session ticket failed: " + e);
        }
    }

    public static void usage() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(79);
        helpFormatter.printHelp("kwik <host>:<port> OR kwik <host> <port> \tOR kwik http[s]://host:port[/path]", cmdLineOptions);
    }

    static {
        DEFAULT_LOG_ARGS = "wip";
    }

    public static enum HttpVersion {
        HTTP09,
        HTTP3;

    }
}

