/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.recovery;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import net.luminis.quic.frame.AckFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.recovery.PacketStatus;

public class RttEstimator {
    private final Logger log;
    private volatile int initialRtt;
    private volatile int minRtt = Integer.MAX_VALUE;
    private volatile int smoothedRtt = 0;
    private volatile int rttVar;
    private volatile int latestRtt;
    private volatile int maxAckDelay;

    public RttEstimator(Logger log) {
        this.log = log;
        this.initialRtt = 500;
        this.maxAckDelay = 25;
    }

    public RttEstimator(Logger log, int initialRtt) {
        this.log = log;
        this.initialRtt = initialRtt;
    }

    public void addSample(Instant timeReceived, Instant timeSent, int ackDelay) {
        if (timeReceived.isBefore(timeSent)) {
            this.log.error("Receiving negative rtt estimate: sent=" + timeSent + ", received=" + timeReceived);
            return;
        }
        if (ackDelay > this.maxAckDelay) {
            ackDelay = this.maxAckDelay;
        }
        int previousSmoothed = this.smoothedRtt;
        int rttSample = Duration.between(timeSent, timeReceived).getNano() / 1000000;
        if (rttSample < this.minRtt) {
            this.minRtt = rttSample;
        }
        if (rttSample >= this.minRtt + ackDelay) {
            rttSample -= ackDelay;
        }
        this.latestRtt = rttSample;
        if (this.smoothedRtt == 0) {
            this.smoothedRtt = rttSample;
            this.rttVar = rttSample / 2;
        } else {
            int currentRttVar = Math.abs(this.smoothedRtt - rttSample);
            this.rttVar = 3 * this.rttVar / 4 + currentRttVar / 4;
            this.smoothedRtt = 7 * this.smoothedRtt / 8 + rttSample / 8;
        }
        this.log.debug("RTT: " + previousSmoothed + " + " + rttSample + " -> " + this.smoothedRtt);
    }

    public int getSmoothedRtt() {
        if (this.smoothedRtt == 0) {
            return this.initialRtt;
        }
        return this.smoothedRtt;
    }

    public int getRttVar() {
        if (this.rttVar == 0) {
            return this.initialRtt / 4;
        }
        return this.rttVar;
    }

    public void ackReceived(AckFrame ack, Instant timeReceived, List<PacketStatus> newlyAcked) {
        Optional<PacketStatus> largestAcked = newlyAcked.stream().filter(s -> s.packet().getPacketNumber().longValue() == ack.getLargestAcknowledged()).findFirst();
        if (largestAcked.isPresent() && newlyAcked.stream().anyMatch(s -> s.packet().isAckEliciting())) {
            this.addSample(timeReceived, largestAcked.get().timeSent(), ack.getAckDelay());
        }
    }

    public int getLatestRtt() {
        return this.latestRtt;
    }

    public void setMaxAckDelay(int maxAckDelay) {
        this.maxAckDelay = maxAckDelay;
    }
}

