/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.qlog.event;

import java.time.Instant;
import net.luminis.quic.qlog.QLogEvent;
import net.luminis.quic.qlog.event.QLogEventProcessor;

public class ConnectionClosedEvent
extends QLogEvent {
    private final Trigger trigger;
    private final Integer transportErrorCode;
    private final String errorReason;

    public ConnectionClosedEvent(byte[] cid, Instant time, Trigger trigger) {
        super(cid, time);
        this.trigger = trigger;
        this.transportErrorCode = null;
        this.errorReason = null;
    }

    public ConnectionClosedEvent(byte[] cid, Instant time, Trigger trigger, int transportErrorCode, String errorReason) {
        super(cid, time);
        this.trigger = trigger;
        this.transportErrorCode = transportErrorCode;
        this.errorReason = errorReason;
    }

    @Override
    public void accept(QLogEventProcessor processor) {
        processor.process(this);
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public Integer getTransportErrorCode() {
        return this.transportErrorCode;
    }

    public String getErrorReason() {
        return this.errorReason;
    }

    public static enum Trigger {
        idleTimeout("idle_timeout"),
        immediateClose("error");

        private final String qlogFormat;

        private Trigger(String qlogFormat) {
            this.qlogFormat = qlogFormat;
        }

        public String qlogFormat() {
            return this.qlogFormat;
        }
    }
}

