/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.qlog;

import java.io.File;
import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import net.luminis.quic.packet.QuicPacket;
import net.luminis.quic.qlog.QLog;
import net.luminis.quic.qlog.QLogBackEnd;
import net.luminis.quic.qlog.QLogEvent;
import net.luminis.quic.qlog.event.CongestionControlMetricsEvent;
import net.luminis.quic.qlog.event.ConnectionClosedEvent;
import net.luminis.quic.qlog.event.ConnectionCreatedEvent;
import net.luminis.quic.qlog.event.ConnectionTerminatedEvent;
import net.luminis.quic.qlog.event.PacketReceivedEvent;
import net.luminis.quic.qlog.event.PacketSentEvent;

public class QLogFrontEnd
implements QLog {
    private final byte[] originalDcid;
    private final Queue<QLogEvent> eventQueue;

    public QLogFrontEnd(byte[] originalDestinationConnectionId) {
        this.originalDcid = originalDestinationConnectionId;
        String qlogdirEnvVar = System.getenv("QLOGDIR");
        if (qlogdirEnvVar != null && !qlogdirEnvVar.isBlank()) {
            this.eventQueue = new QLogBackEnd().getQueue();
            File qlogDir = new File(qlogdirEnvVar);
            if (!qlogDir.exists()) {
                qlogDir.mkdirs();
            }
        } else {
            this.eventQueue = new NullQueue();
        }
    }

    @Override
    public void emitConnectionCreatedEvent(Instant created) {
        this.eventQueue.add(new ConnectionCreatedEvent(this.originalDcid, created));
    }

    @Override
    public void emitPacketSentEvent(QuicPacket packet, Instant sent) {
        this.eventQueue.add(new PacketSentEvent(this.originalDcid, packet, sent));
    }

    @Override
    public void emitPacketSentEvent(List<QuicPacket> packets, Instant sent) {
        packets.stream().forEach(packet -> this.eventQueue.add(new PacketSentEvent(this.originalDcid, (QuicPacket)packet, sent)));
    }

    @Override
    public void emitPacketReceivedEvent(QuicPacket packet, Instant received) {
        this.eventQueue.add(new PacketReceivedEvent(this.originalDcid, packet, received));
    }

    @Override
    public void emitConnectionTerminatedEvent() {
        this.eventQueue.add(new ConnectionTerminatedEvent(this.originalDcid));
    }

    @Override
    public void emitCongestionControlMetrics(long congestionWindow, long bytesInFlight) {
        this.eventQueue.add(new CongestionControlMetricsEvent(this.originalDcid, congestionWindow, bytesInFlight, Instant.now()));
    }

    @Override
    public void emitConnectionClosedEvent(Instant time) {
        this.eventQueue.add(new ConnectionClosedEvent(this.originalDcid, time, ConnectionClosedEvent.Trigger.idleTimeout));
    }

    @Override
    public void emitConnectionClosedEvent(Instant time, int transportErrorCode, String errorReason) {
        this.eventQueue.add(new ConnectionClosedEvent(this.originalDcid, time, ConnectionClosedEvent.Trigger.immediateClose, transportErrorCode, errorReason));
    }

    private static class NullQueue
    implements Queue<QLogEvent> {
        private NullQueue() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public Iterator<QLogEvent> iterator() {
            return null;
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return null;
        }

        @Override
        public boolean add(QLogEvent qLogEvent) {
            return false;
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends QLogEvent> c) {
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return false;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean offer(QLogEvent qLogEvent) {
            return false;
        }

        @Override
        public QLogEvent remove() {
            return null;
        }

        @Override
        public QLogEvent poll() {
            return null;
        }

        @Override
        public QLogEvent element() {
            return null;
        }

        @Override
        public QLogEvent peek() {
            return null;
        }
    }
}

