/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.qlog;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import net.luminis.quic.packet.LongHeaderPacket;
import net.luminis.quic.packet.QuicPacket;
import net.luminis.quic.packet.RetryPacket;
import net.luminis.quic.qlog.FrameFormatter;
import net.luminis.quic.qlog.QLogEvent;
import net.luminis.quic.qlog.event.CongestionControlMetricsEvent;
import net.luminis.quic.qlog.event.ConnectionClosedEvent;
import net.luminis.quic.qlog.event.ConnectionCreatedEvent;
import net.luminis.quic.qlog.event.ConnectionTerminatedEvent;
import net.luminis.quic.qlog.event.PacketEvent;
import net.luminis.quic.qlog.event.PacketReceivedEvent;
import net.luminis.quic.qlog.event.PacketSentEvent;
import net.luminis.quic.qlog.event.QLogEventProcessor;
import net.luminis.tls.util.ByteUtils;

public class ConnectionQLog
implements QLogEventProcessor {
    private final byte[] cid;
    private final Instant startTime;
    private final JsonGenerator jsonGenerator;
    private final FrameFormatter frameFormatter;
    private boolean closed;

    public ConnectionQLog(QLogEvent event) throws IOException {
        this.cid = event.getCid();
        this.startTime = event.getTime();
        String qlogDir = System.getenv("QLOGDIR");
        FileOutputStream output = new FileOutputStream(new File(qlogDir, this.format(this.cid) + ".qlog"));
        boolean prettyPrinting = false;
        Map configuration = prettyPrinting ? Map.of("javax.json.stream.JsonGenerator.prettyPrinting", "whatever") : Collections.emptyMap();
        this.jsonGenerator = Json.createGeneratorFactory(configuration).createGenerator(output);
        this.frameFormatter = new FrameFormatter(this.jsonGenerator);
        this.writeHeader();
    }

    @Override
    public void process(PacketSentEvent event) {
        this.writePacketEvent(event);
    }

    @Override
    public void process(ConnectionCreatedEvent event) {
    }

    @Override
    public void process(ConnectionClosedEvent event) {
        this.emitConnectionClosedEvent(event);
    }

    @Override
    public void process(PacketReceivedEvent event) {
        this.writePacketEvent(event);
    }

    @Override
    public void process(ConnectionTerminatedEvent event) {
        this.close();
    }

    @Override
    public void process(CongestionControlMetricsEvent event) {
        this.emitMetrics(event);
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.writeFooter();
        }
    }

    private void writeHeader() {
        this.jsonGenerator.writeStartObject().write("qlog_version", "draft-02").write("qlog_format", "JSON").writeStartArray("traces").writeStartObject().writeStartObject("common_fields").write("ODCID", ByteUtils.bytesToHex(this.cid)).write("time_format", "relative").write("reference_time", this.startTime.toEpochMilli()).writeEnd().writeStartObject("vantage_point").write("name", "kwik").write("type", "server").writeEnd().writeStartArray("events");
    }

    private void writePacketEvent(PacketEvent event) {
        QuicPacket packet = event.getPacket();
        this.jsonGenerator.writeStartObject().write("time", Duration.between(this.startTime, event.getTime()).toMillis()).write("name", "transport:" + (event instanceof PacketReceivedEvent ? "packet_received" : "packet_sent")).writeStartObject("data").writeStartObject("header").write("packet_type", this.formatPacketType(packet)).write("packet_number", packet.getPacketNumber() != null ? packet.getPacketNumber() : 0L).write("dcid", this.format(packet.getDestinationConnectionId()));
        if (packet instanceof LongHeaderPacket) {
            this.jsonGenerator.write("scid", this.format(((LongHeaderPacket)packet).getSourceConnectionId()));
        }
        this.jsonGenerator.writeEnd();
        this.jsonGenerator.writeStartArray("frames");
        packet.getFrames().stream().forEach(frame -> frame.accept(this.frameFormatter, null, null));
        this.jsonGenerator.writeEnd().writeStartObject("raw").write("length", packet.getSize()).writeEnd().writeEnd().writeEnd();
    }

    private void emitMetrics(CongestionControlMetricsEvent event) {
        this.jsonGenerator.writeStartObject().write("time", Duration.between(this.startTime, event.getTime()).toMillis()).write("name", "recovery:metrics_updated").writeStartObject("data").write("bytes_in_flight", event.getBytesInFlight()).write("congestion_window", event.getCongestionWindow()).writeEnd().writeEnd();
    }

    private void emitConnectionClosedEvent(ConnectionClosedEvent event) {
        this.jsonGenerator.writeStartObject().write("time", Duration.between(this.startTime, event.getTime()).toMillis()).write("name", "connectivity:connection_closed").writeStartObject("data").write("trigger", event.getTrigger().qlogFormat());
        if (event.getTransportErrorCode() != null) {
            this.jsonGenerator.write("connection_code", event.getTransportErrorCode());
        }
        if (event.getErrorReason() != null) {
            this.jsonGenerator.write("reason", event.getErrorReason());
        }
        this.jsonGenerator.writeEnd().writeEnd();
    }

    private String formatPacketType(QuicPacket packet) {
        if (packet instanceof RetryPacket) {
            return "retry";
        }
        if (packet instanceof LongHeaderPacket) {
            return packet.getEncryptionLevel().name().toLowerCase();
        }
        return "1RTT";
    }

    private String format(byte[] data) {
        return ByteUtils.bytesToHex(data);
    }

    private void writeFooter() {
        this.jsonGenerator.writeEnd().writeEnd().writeEnd().writeEnd();
        this.jsonGenerator.close();
        System.out.println("QLog: done with " + this.format(this.cid) + ".qlog");
    }
}

