/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.packet;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.luminis.quic.DecryptionException;
import net.luminis.quic.EncryptionLevel;
import net.luminis.quic.ImplementationError;
import net.luminis.quic.InvalidPacketException;
import net.luminis.quic.NotYetImplementedException;
import net.luminis.quic.PacketProcessor;
import net.luminis.quic.PnSpace;
import net.luminis.quic.UnknownVersionException;
import net.luminis.quic.Version;
import net.luminis.quic.crypto.Keys;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;

public class VersionNegotiationPacket
extends QuicPacket {
    private static int MIN_PACKET_LENGTH = 11;
    private static Random random = new Random();
    private byte[] sourceConnectionId;
    private byte[] destinationConnectionId;
    private int packetSize;
    private List<Version> serverSupportedVersions = new ArrayList<Version>();

    public VersionNegotiationPacket() {
        this(Version.getDefault());
    }

    public VersionNegotiationPacket(Version quicVersion) {
        this.quicVersion = quicVersion;
    }

    public VersionNegotiationPacket(Version quicVersion, byte[] sourceConnectionId, byte[] destinationConnectionId) {
        this.serverSupportedVersions = List.of(quicVersion);
        this.sourceConnectionId = sourceConnectionId;
        this.destinationConnectionId = destinationConnectionId;
    }

    public VersionNegotiationPacket(List<Version> supportedVersions, byte[] sourceConnectionId, byte[] destinationConnectionId) {
        this.serverSupportedVersions = supportedVersions;
        this.sourceConnectionId = sourceConnectionId;
        this.destinationConnectionId = destinationConnectionId;
    }

    public List<Version> getServerSupportedVersions() {
        return this.serverSupportedVersions;
    }

    @Override
    public void parse(ByteBuffer buffer, Keys keys, long largestPacketNumber, Logger log, int sourceConnectionIdLength) throws DecryptionException, InvalidPacketException {
        log.debug("Parsing VersionNegotationPacket");
        int packetLength = buffer.limit() - buffer.position();
        if (packetLength < MIN_PACKET_LENGTH) {
            throw new InvalidPacketException();
        }
        buffer.get();
        int zeroVersion = buffer.getInt();
        if (zeroVersion != 0) {
            throw new ImplementationError();
        }
        int dstConnIdLength = buffer.get() & 0xFF;
        if (packetLength < MIN_PACKET_LENGTH + dstConnIdLength) {
            throw new InvalidPacketException();
        }
        this.destinationConnectionId = new byte[dstConnIdLength];
        buffer.get(this.destinationConnectionId);
        int srcConnIdLength = buffer.get() & 0xFF;
        if (packetLength < MIN_PACKET_LENGTH + dstConnIdLength + srcConnIdLength) {
            throw new InvalidPacketException();
        }
        this.sourceConnectionId = new byte[srcConnIdLength];
        buffer.get(this.sourceConnectionId);
        log.debug("Destination connection id", this.destinationConnectionId);
        log.debug("Source connection id", this.sourceConnectionId);
        while (buffer.remaining() >= 4) {
            int versionData = buffer.getInt();
            Version supportedVersion = this.parseVersion(versionData);
            if (supportedVersion != null) {
                this.serverSupportedVersions.add(supportedVersion);
                log.debug("Server supports version " + supportedVersion);
                continue;
            }
            log.debug(String.format("Server supports unknown version %x", versionData));
        }
        this.packetSize = buffer.limit();
    }

    private Version parseVersion(int versionData) {
        try {
            return Version.parse(versionData);
        }
        catch (UnknownVersionException e) {
            return null;
        }
    }

    @Override
    public EncryptionLevel getEncryptionLevel() {
        return null;
    }

    @Override
    public PnSpace getPnSpace() {
        return null;
    }

    @Override
    public Long getPacketNumber() {
        return null;
    }

    @Override
    public int estimateLength(int additionalPayload) {
        throw new NotYetImplementedException();
    }

    @Override
    public byte[] generatePacketBytes(Long packetNumber, Keys keys) {
        ByteBuffer buffer = ByteBuffer.allocate(6 + this.destinationConnectionId.length + 1 + this.sourceConnectionId.length + 4 * this.serverSupportedVersions.size());
        buffer.put((byte)((byte)random.nextInt(256) | 0xC0));
        buffer.putInt(0);
        buffer.put((byte)this.destinationConnectionId.length);
        buffer.put(this.destinationConnectionId);
        buffer.put((byte)this.sourceConnectionId.length);
        buffer.put(this.sourceConnectionId);
        this.serverSupportedVersions.forEach(version -> buffer.put(version.getBytes()));
        return buffer.array();
    }

    @Override
    public PacketProcessor.ProcessResult accept(PacketProcessor processor, Instant time) {
        return processor.process(this, time);
    }

    @Override
    public boolean canBeAcked() {
        return false;
    }

    public String toString() {
        return "Packet V|-|V|" + (Serializable)(this.packetSize >= 0 ? Integer.valueOf(this.packetSize) : ".") + "|0  " + this.serverSupportedVersions.stream().map(v -> v.toString()).collect(Collectors.joining(", "));
    }

    public byte[] getScid() {
        return this.sourceConnectionId;
    }

    public byte[] getDcid() {
        return this.destinationConnectionId;
    }
}

