/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.packet;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import net.luminis.quic.DecryptionException;
import net.luminis.quic.EncryptionLevel;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.InvalidPacketException;
import net.luminis.quic.NotYetImplementedException;
import net.luminis.quic.PacketProcessor;
import net.luminis.quic.PnSpace;
import net.luminis.quic.ProtocolError;
import net.luminis.quic.Version;
import net.luminis.quic.crypto.Keys;
import net.luminis.quic.frame.AckFrame;
import net.luminis.quic.frame.ConnectionCloseFrame;
import net.luminis.quic.frame.CryptoFrame;
import net.luminis.quic.frame.DataBlockedFrame;
import net.luminis.quic.frame.HandshakeDoneFrame;
import net.luminis.quic.frame.MaxDataFrame;
import net.luminis.quic.frame.MaxStreamDataFrame;
import net.luminis.quic.frame.MaxStreamsFrame;
import net.luminis.quic.frame.NewConnectionIdFrame;
import net.luminis.quic.frame.NewTokenFrame;
import net.luminis.quic.frame.Padding;
import net.luminis.quic.frame.PathChallengeFrame;
import net.luminis.quic.frame.PathResponseFrame;
import net.luminis.quic.frame.PingFrame;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.frame.ResetStreamFrame;
import net.luminis.quic.frame.RetireConnectionIdFrame;
import net.luminis.quic.frame.StopSendingFrame;
import net.luminis.quic.frame.StreamDataBlockedFrame;
import net.luminis.quic.frame.StreamFrame;
import net.luminis.quic.frame.StreamsBlockedFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.ShortHeaderPacket;

public abstract class QuicPacket {
    protected static final int MAX_PACKET_SIZE = 1500;
    protected Version quicVersion;
    protected long packetNumber = -1L;
    protected List<QuicFrame> frames = new ArrayList<QuicFrame>();
    protected int packetSize = -1;
    protected byte[] destinationConnectionId;
    protected boolean isProbe;

    static byte[] encodePacketNumber(long packetNumber) {
        if (packetNumber <= 255L) {
            return new byte[]{(byte)packetNumber};
        }
        if (packetNumber <= 65535L) {
            return new byte[]{(byte)(packetNumber >> 8), (byte)(packetNumber & 0xFFL)};
        }
        if (packetNumber <= 0xFFFFFFL) {
            return new byte[]{(byte)(packetNumber >> 16), (byte)(packetNumber >> 8), (byte)(packetNumber & 0xFFL)};
        }
        if (packetNumber <= 0xFFFFFFFFL) {
            return new byte[]{(byte)(packetNumber >> 24), (byte)(packetNumber >> 16), (byte)(packetNumber >> 8), (byte)(packetNumber & 0xFFL)};
        }
        throw new NotYetImplementedException("cannot encode pn > 4 bytes");
    }

    static byte encodePacketNumberLength(byte flags, long packetNumber) {
        if (packetNumber <= 255L) {
            return flags;
        }
        if (packetNumber <= 65535L) {
            return (byte)(flags | 1);
        }
        if (packetNumber <= 0xFFFFFFL) {
            return (byte)(flags | 2);
        }
        if (packetNumber <= 0xFFFFFFFFL) {
            return (byte)(flags | 3);
        }
        throw new NotYetImplementedException("cannot encode pn > 4 bytes");
    }

    void parsePacketNumberAndPayload(ByteBuffer buffer, byte flags, int remainingLength, Keys serverSecrets, long largestPacketNumber, Logger log) throws DecryptionException, InvalidPacketException {
        if (buffer.remaining() < remainingLength) {
            throw new InvalidPacketException();
        }
        int currentPosition = buffer.position();
        if (buffer.remaining() < 4) {
            throw new InvalidPacketException();
        }
        buffer.position(currentPosition + 4);
        if (buffer.remaining() < 16) {
            throw new InvalidPacketException();
        }
        byte[] sample = new byte[16];
        buffer.get(sample);
        byte[] mask = this.createHeaderProtectionMask(sample, serverSecrets);
        byte decryptedFlags = (flags & 0x80) == 128 ? (byte)(flags ^ mask[0] & 0xF) : (byte)(flags ^ mask[0] & 0x1F);
        this.setUnprotectedHeader(decryptedFlags);
        buffer.position(currentPosition);
        int protectedPackageNumberLength = (decryptedFlags & 3) + 1;
        byte[] protectedPackageNumber = new byte[protectedPackageNumberLength];
        buffer.get(protectedPackageNumber);
        byte[] unprotectedPacketNumber = new byte[protectedPackageNumberLength];
        for (int i = 0; i < protectedPackageNumberLength; ++i) {
            unprotectedPacketNumber[i] = (byte)(protectedPackageNumber[i] ^ mask[1 + i]);
        }
        this.packetNumber = QuicPacket.bytesToInt(unprotectedPacketNumber);
        this.packetNumber = QuicPacket.decodePacketNumber(this.packetNumber, largestPacketNumber, protectedPackageNumberLength * 8);
        log.decrypted("Unprotected packet number: " + this.packetNumber);
        currentPosition = buffer.position();
        byte[] frameHeader = new byte[buffer.position()];
        buffer.position(0);
        buffer.get(frameHeader);
        frameHeader[0] = decryptedFlags;
        buffer.position(currentPosition);
        System.arraycopy(unprotectedPacketNumber, 0, frameHeader, frameHeader.length - protectedPackageNumberLength, protectedPackageNumberLength);
        log.encrypted("Frame header", frameHeader);
        int encryptedPayloadLength = remainingLength - protectedPackageNumberLength;
        if (encryptedPayloadLength < 1) {
            throw new InvalidPacketException();
        }
        byte[] payload = new byte[encryptedPayloadLength];
        buffer.get(payload, 0, encryptedPayloadLength);
        log.encrypted("Encrypted payload", payload);
        byte[] frameBytes = this.decryptPayload(payload, frameHeader, this.packetNumber, serverSecrets);
        log.decrypted("Decrypted payload", frameBytes);
        this.frames = new ArrayList<QuicFrame>();
        try {
            this.parseFrames(frameBytes, log);
        }
        catch (InvalidIntegerEncodingException e) {
            throw new InvalidPacketException();
        }
    }

    protected void setUnprotectedHeader(byte decryptedFlags) {
    }

    byte[] createHeaderProtectionMask(byte[] sample, Keys secrets) {
        return this.createHeaderProtectionMask(sample, 4, secrets);
    }

    byte[] createHeaderProtectionMask(byte[] ciphertext, int encodedPacketNumberLength, Keys secrets) {
        int sampleOffset = 4 - encodedPacketNumberLength;
        byte[] sample = new byte[16];
        System.arraycopy(ciphertext, sampleOffset, sample, 0, 16);
        return secrets.createHeaderProtectionMask(sample);
    }

    byte[] encryptPayload(byte[] message, byte[] associatedData, long packetNumber, Keys secrets) {
        byte[] writeIV = secrets.getWriteIV();
        ByteBuffer nonceInput = ByteBuffer.allocate(writeIV.length);
        for (int i = 0; i < nonceInput.capacity() - 8; ++i) {
            nonceInput.put((byte)0);
        }
        nonceInput.putLong(packetNumber);
        byte[] nonce = new byte[12];
        int i = 0;
        for (byte b : nonceInput.array()) {
            nonce[i] = (byte)(b ^ writeIV[i++]);
        }
        return secrets.aeadEncrypt(associatedData, message, nonce);
    }

    byte[] decryptPayload(byte[] message, byte[] associatedData, long packetNumber, Keys secrets) throws DecryptionException {
        ByteBuffer nonceInput = ByteBuffer.allocate(12);
        nonceInput.putInt(0);
        nonceInput.putLong(packetNumber);
        if (this instanceof ShortHeaderPacket) {
            secrets.checkKeyPhase(((ShortHeaderPacket)this).keyPhaseBit);
        }
        byte[] writeIV = secrets.getWriteIV();
        byte[] nonce = new byte[12];
        int i = 0;
        for (byte b : nonceInput.array()) {
            nonce[i] = (byte)(b ^ writeIV[i++]);
        }
        return secrets.aeadDecrypt(associatedData, message, nonce);
    }

    static long decodePacketNumber(long truncatedPacketNumber, long largestPacketNumber, int bits) {
        long expectedPacketNumber = largestPacketNumber + 1L;
        long pnWindow = 1L << bits;
        long pnMask = pnWindow - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        long candidatePn = expectedPacketNumber & pnMask | truncatedPacketNumber;
        long pnHalfWindow = pnWindow / 2L;
        if (candidatePn <= expectedPacketNumber - pnHalfWindow && candidatePn < 0x40000000L - pnWindow) {
            return candidatePn + pnWindow;
        }
        if (candidatePn > expectedPacketNumber + pnHalfWindow && candidatePn >= pnWindow) {
            return candidatePn - pnWindow;
        }
        return candidatePn;
    }

    protected void parseFrames(byte[] frameBytes, Logger log) throws InvalidIntegerEncodingException {
        ByteBuffer buffer = ByteBuffer.wrap(frameBytes);
        block21: while (buffer.remaining() > 0) {
            buffer.mark();
            byte frameType = buffer.get();
            buffer.reset();
            switch (frameType) {
                case 0: {
                    this.frames.add(new Padding().parse(buffer, log));
                    continue block21;
                }
                case 1: {
                    this.frames.add(new PingFrame(this.quicVersion).parse(buffer, log));
                    continue block21;
                }
                case 2: 
                case 3: {
                    this.frames.add(new AckFrame().parse(buffer, log));
                    continue block21;
                }
                case 4: {
                    this.frames.add(new ResetStreamFrame().parse(buffer, log));
                    continue block21;
                }
                case 5: {
                    this.frames.add(new StopSendingFrame(this.quicVersion).parse(buffer, log));
                    continue block21;
                }
                case 6: {
                    this.frames.add(new CryptoFrame().parse(buffer, log));
                    continue block21;
                }
                case 7: {
                    this.frames.add(new NewTokenFrame().parse(buffer, log));
                    continue block21;
                }
                case 16: {
                    this.frames.add(new MaxDataFrame().parse(buffer, log));
                    continue block21;
                }
                case 17: {
                    this.frames.add(new MaxStreamDataFrame().parse(buffer, log));
                    continue block21;
                }
                case 18: 
                case 19: {
                    this.frames.add(new MaxStreamsFrame().parse(buffer, log));
                    continue block21;
                }
                case 20: {
                    this.frames.add(new DataBlockedFrame().parse(buffer, log));
                    continue block21;
                }
                case 21: {
                    this.frames.add(new StreamDataBlockedFrame().parse(buffer, log));
                    continue block21;
                }
                case 22: 
                case 23: {
                    this.frames.add(new StreamsBlockedFrame().parse(buffer, log));
                    continue block21;
                }
                case 24: {
                    this.frames.add(new NewConnectionIdFrame(this.quicVersion).parse(buffer, log));
                    continue block21;
                }
                case 25: {
                    this.frames.add(new RetireConnectionIdFrame(this.quicVersion).parse(buffer, log));
                    continue block21;
                }
                case 26: {
                    this.frames.add(new PathChallengeFrame(this.quicVersion).parse(buffer, log));
                    continue block21;
                }
                case 27: {
                    this.frames.add(new PathResponseFrame(this.quicVersion).parse(buffer, log));
                    continue block21;
                }
                case 28: 
                case 29: {
                    this.frames.add(new ConnectionCloseFrame(this.quicVersion).parse(buffer, log));
                    continue block21;
                }
                case 30: {
                    this.frames.add(new HandshakeDoneFrame(this.quicVersion).parse(buffer, log));
                    continue block21;
                }
            }
            if (frameType >= 8 && frameType <= 15) {
                this.frames.add(new StreamFrame().parse(buffer, log));
                continue;
            }
            throw new ProtocolError("connection error FRAME_ENCODING_ERROR");
        }
    }

    public Long getPacketNumber() {
        if (this.packetNumber >= 0L) {
            return this.packetNumber;
        }
        throw new IllegalStateException("PN is not yet known");
    }

    public void setPacketNumber(long pn) {
        if (pn < 0L) {
            throw new IllegalArgumentException();
        }
        this.packetNumber = pn;
    }

    protected ByteBuffer generatePayloadBytes(int encodedPacketNumberLength) {
        ByteBuffer frameBytes = ByteBuffer.allocate(1500);
        this.frames.stream().forEachOrdered(frame -> frameBytes.put(frame.getBytes()));
        int serializeFramesLength = frameBytes.position();
        if (encodedPacketNumberLength + serializeFramesLength < 4) {
            Padding padding = new Padding(4 - encodedPacketNumberLength - frameBytes.position());
            this.frames.add(padding);
            frameBytes.put(padding.getBytes());
        }
        frameBytes.flip();
        return frameBytes;
    }

    protected void protectPacketNumberAndPayload(ByteBuffer packetBuffer, int packetNumberSize, ByteBuffer payload, int paddingSize, Keys clientSecrets) {
        int packetNumberPosition = packetBuffer.position() - packetNumberSize;
        int additionalDataSize = packetBuffer.position();
        byte[] additionalData = new byte[additionalDataSize];
        packetBuffer.flip();
        packetBuffer.get(additionalData);
        packetBuffer.limit(packetBuffer.capacity());
        byte[] paddedPayload = new byte[payload.limit() + paddingSize];
        payload.get(paddedPayload, 0, payload.limit());
        byte[] encryptedPayload = this.encryptPayload(paddedPayload, additionalData, this.packetNumber, clientSecrets);
        packetBuffer.put(encryptedPayload);
        byte[] encodedPacketNumber = QuicPacket.encodePacketNumber(this.packetNumber);
        byte[] mask = this.createHeaderProtectionMask(encryptedPayload, encodedPacketNumber.length, clientSecrets);
        byte[] protectedPacketNumber = new byte[encodedPacketNumber.length];
        for (int i = 0; i < encodedPacketNumber.length; ++i) {
            protectedPacketNumber[i] = (byte)(encodedPacketNumber[i] ^ mask[1 + i]);
        }
        byte flags = packetBuffer.get(0);
        flags = (flags & 0x80) == 128 ? (byte)(flags ^ mask[0] & 0xF) : (byte)(flags ^ mask[0] & 0x1F);
        packetBuffer.put(0, flags);
        int currentPosition = packetBuffer.position();
        packetBuffer.position(packetNumberPosition);
        packetBuffer.put(protectedPacketNumber);
        packetBuffer.position(currentPosition);
    }

    static int bytesToInt(byte[] data) {
        int value = 0;
        for (int i = 0; i < data.length; ++i) {
            value = value << 8 | data[i] & 0xFF;
        }
        return value;
    }

    public void addFrame(QuicFrame frame) {
        this.frames.add(frame);
    }

    public void addFrames(List<QuicFrame> frames) {
        this.frames.addAll(frames);
    }

    public int getSize() {
        if (this.packetSize > 0) {
            return this.packetSize;
        }
        throw new IllegalStateException("no size");
    }

    public abstract int estimateLength(int var1);

    public abstract EncryptionLevel getEncryptionLevel();

    public abstract PnSpace getPnSpace();

    public abstract byte[] generatePacketBytes(Long var1, Keys var2);

    public abstract void parse(ByteBuffer var1, Keys var2, long var3, Logger var5, int var6) throws DecryptionException, InvalidPacketException;

    public List<QuicFrame> getFrames() {
        return this.frames;
    }

    public abstract PacketProcessor.ProcessResult accept(PacketProcessor var1, Instant var2);

    public boolean isCrypto() {
        return !this.getEncryptionLevel().equals((Object)EncryptionLevel.App) && this.frames.stream().filter(f -> f instanceof CryptoFrame).findFirst().isPresent();
    }

    public QuicPacket copy() {
        throw new IllegalStateException();
    }

    public boolean canBeAcked() {
        return true;
    }

    public boolean isAckEliciting() {
        return this.frames.stream().anyMatch(frame -> frame.isAckEliciting());
    }

    public boolean isAckOnly() {
        return this.frames.stream().allMatch(frame -> frame instanceof AckFrame);
    }

    public boolean isInflightPacket() {
        return this.frames.stream().anyMatch(frame -> frame.isAckEliciting() || frame instanceof Padding);
    }

    public byte[] getDestinationConnectionId() {
        return this.destinationConnectionId;
    }

    public void setIsProbe(boolean probe) {
        this.isProbe = probe;
    }

    public Version getVersion() {
        return this.quicVersion;
    }
}

