/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.packet;

import java.io.Serializable;
import java.time.Instant;
import java.util.function.Consumer;
import net.luminis.quic.packet.QuicPacket;

public class PacketInfo {
    final Instant timeSent;
    final QuicPacket packet;
    final Consumer<QuicPacket> lostPacketCallback;

    public PacketInfo(Instant sent, QuicPacket packet, Consumer<QuicPacket> lostPacketCallback) {
        this.timeSent = sent;
        this.packet = packet;
        this.lostPacketCallback = lostPacketCallback;
    }

    public Instant timeSent() {
        return this.timeSent;
    }

    public QuicPacket packet() {
        return this.packet;
    }

    public Consumer lostPacketCallback() {
        return this.lostPacketCallback;
    }

    public String toString() {
        return "Packet " + this.packet.getEncryptionLevel().name().charAt(0) + "|" + (Serializable)(this.packet.packetNumber >= 0L ? Long.valueOf(this.packet.packetNumber) : ".");
    }
}

