/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.packet;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.luminis.quic.DecryptionException;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.InvalidPacketException;
import net.luminis.quic.UnknownVersionException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.Version;
import net.luminis.quic.crypto.Keys;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;

public abstract class LongHeaderPacket
extends QuicPacket {
    private static final int MAX_PACKET_SIZE = 1500;
    private static int MIN_PACKET_LENGTH = 10;
    protected byte[] sourceConnectionId;

    public LongHeaderPacket(Version quicVersion) {
        this.quicVersion = quicVersion;
    }

    public LongHeaderPacket(Version quicVersion, byte[] sourceConnectionId, byte[] destConnectionId, QuicFrame frame) {
        this.quicVersion = quicVersion;
        this.sourceConnectionId = sourceConnectionId;
        this.destinationConnectionId = destConnectionId;
        this.frames = new ArrayList();
        if (frame != null) {
            this.frames.add(frame);
        }
    }

    public LongHeaderPacket(Version quicVersion, byte[] sourceConnectionId, byte[] destConnectionId, List<QuicFrame> frames) {
        this.quicVersion = quicVersion;
        this.sourceConnectionId = sourceConnectionId;
        this.destinationConnectionId = destConnectionId;
        this.frames = frames;
    }

    @Override
    public byte[] generatePacketBytes(Long packetNumber, Keys keys) {
        this.packetNumber = packetNumber;
        ByteBuffer packetBuffer = ByteBuffer.allocate(1500);
        this.generateFrameHeaderInvariant(packetBuffer);
        this.generateAdditionalFields(packetBuffer);
        byte[] encodedPacketNumber = LongHeaderPacket.encodePacketNumber(packetNumber);
        ByteBuffer frameBytes = this.generatePayloadBytes(encodedPacketNumber.length);
        this.addLength(packetBuffer, encodedPacketNumber.length, frameBytes.limit());
        packetBuffer.put(encodedPacketNumber);
        this.protectPacketNumberAndPayload(packetBuffer, encodedPacketNumber.length, frameBytes, 0, keys);
        packetBuffer.limit(packetBuffer.position());
        this.packetSize = packetBuffer.limit();
        byte[] packetBytes = new byte[packetBuffer.position()];
        packetBuffer.rewind();
        packetBuffer.get(packetBytes);
        this.packetSize = packetBytes.length;
        return packetBytes;
    }

    @Override
    public int estimateLength(int additionalPayload) {
        int payloadLength = this.getFrames().stream().mapToInt(f -> f.getBytes().length).sum() + additionalPayload;
        return 6 + this.destinationConnectionId.length + 1 + this.sourceConnectionId.length + this.estimateAdditionalFieldsLength() + (payloadLength + 1 > 63 ? 2 : 1) + 1 + payloadLength + 16;
    }

    protected void generateFrameHeaderInvariant(ByteBuffer packetBuffer) {
        byte packetType = this.getPacketType();
        packetBuffer.put(packetType);
        packetBuffer.put(this.quicVersion.getBytes());
        packetBuffer.put((byte)this.destinationConnectionId.length);
        packetBuffer.put(this.destinationConnectionId);
        packetBuffer.put((byte)this.sourceConnectionId.length);
        packetBuffer.put(this.sourceConnectionId);
    }

    protected abstract byte getPacketType();

    protected abstract void generateAdditionalFields(ByteBuffer var1);

    protected abstract int estimateAdditionalFieldsLength();

    private void addLength(ByteBuffer packetBuffer, int packetNumberLength, int payloadSize) {
        int packetLength = payloadSize + 16 + packetNumberLength;
        VariableLengthInteger.encode(packetLength, packetBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(ByteBuffer buffer, Keys keys, long largestPacketNumber, Logger log, int sourceConnectionIdLength) throws DecryptionException, InvalidPacketException {
        int length;
        log.debug("Parsing " + this.getClass().getSimpleName());
        if (buffer.position() != 0) {
            throw new IllegalStateException();
        }
        if (buffer.remaining() < MIN_PACKET_LENGTH) {
            throw new InvalidPacketException();
        }
        byte flags = buffer.get();
        this.checkPacketType(flags);
        boolean matchingVersion = false;
        try {
            matchingVersion = Version.parse(buffer.getInt()) == this.quicVersion;
        }
        catch (UnknownVersionException unknownVersionException) {
            // empty catch block
        }
        if (!matchingVersion) {
            throw new InvalidPacketException("Version does not match version of the connection");
        }
        byte dstConnIdLength = buffer.get();
        if (dstConnIdLength < 0 || dstConnIdLength > 20) {
            throw new InvalidPacketException();
        }
        if (buffer.remaining() < dstConnIdLength) {
            throw new InvalidPacketException();
        }
        this.destinationConnectionId = new byte[dstConnIdLength];
        buffer.get(this.destinationConnectionId);
        byte srcConnIdLength = buffer.get();
        if (srcConnIdLength < 0 || srcConnIdLength > 20) {
            throw new InvalidPacketException();
        }
        if (buffer.remaining() < srcConnIdLength) {
            throw new InvalidPacketException();
        }
        this.sourceConnectionId = new byte[srcConnIdLength];
        buffer.get(this.sourceConnectionId);
        log.debug("Destination connection id", this.destinationConnectionId);
        log.debug("Source connection id", this.sourceConnectionId);
        this.parseAdditionalFields(buffer);
        try {
            length = VariableLengthInteger.parse(buffer);
        }
        catch (IllegalArgumentException | InvalidIntegerEncodingException invalidInt) {
            throw new InvalidPacketException();
        }
        log.debug("Length (PN + payload): " + length);
        try {
            this.parsePacketNumberAndPayload(buffer, flags, length, keys, largestPacketNumber, log);
        }
        finally {
            this.packetSize = buffer.position() - 0;
        }
    }

    public String toString() {
        return "Packet " + (this.isProbe ? "P" : "") + this.getEncryptionLevel().name().charAt(0) + "|" + (Serializable)(this.packetNumber >= 0L ? Long.valueOf(this.packetNumber) : ".") + "|L|" + (Serializable)(this.packetSize >= 0 ? Integer.valueOf(this.packetSize) : ".") + "|" + this.frames.size() + "  " + this.frames.stream().map(f -> f.toString()).collect(Collectors.joining(" "));
    }

    public byte[] getSourceConnectionId() {
        return this.sourceConnectionId;
    }

    protected abstract void checkPacketType(byte var1);

    protected abstract void parseAdditionalFields(ByteBuffer var1) throws InvalidPacketException;
}

