/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.packet;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import net.luminis.quic.EncryptionLevel;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.InvalidPacketException;
import net.luminis.quic.PacketProcessor;
import net.luminis.quic.PnSpace;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.Version;
import net.luminis.quic.frame.Padding;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.packet.LongHeaderPacket;
import net.luminis.tls.util.ByteUtils;

public class InitialPacket
extends LongHeaderPacket {
    private byte[] token;

    public static boolean isInitial(ByteBuffer data) {
        data.mark();
        byte flags = data.get();
        data.rewind();
        return (flags & 0xF0) == 192;
    }

    public InitialPacket(Version quicVersion, byte[] sourceConnectionId, byte[] destConnectionId, byte[] token, QuicFrame payload) {
        super(quicVersion, sourceConnectionId, destConnectionId, payload);
        this.token = token;
    }

    public InitialPacket(Version quicVersion) {
        super(quicVersion);
        this.token = null;
    }

    public InitialPacket(Version quicVersion, byte[] sourceConnectionId, byte[] destConnectionId, byte[] token, List<QuicFrame> frames) {
        super(quicVersion, sourceConnectionId, destConnectionId, frames);
        this.token = token;
    }

    @Override
    public InitialPacket copy() {
        return new InitialPacket(this.quicVersion, this.sourceConnectionId, this.destinationConnectionId, this.token, this.frames);
    }

    @Override
    protected byte getPacketType() {
        byte flags = -64;
        return InitialPacket.encodePacketNumberLength(flags, this.packetNumber);
    }

    @Override
    protected void generateAdditionalFields(ByteBuffer packetBuffer) {
        if (this.token != null) {
            VariableLengthInteger.encode(this.token.length, packetBuffer);
            packetBuffer.put(this.token);
        } else {
            packetBuffer.put((byte)0);
        }
    }

    @Override
    protected int estimateAdditionalFieldsLength() {
        return this.token == null ? 1 : 1 + this.token.length;
    }

    @Override
    public EncryptionLevel getEncryptionLevel() {
        return EncryptionLevel.Initial;
    }

    @Override
    public PnSpace getPnSpace() {
        return PnSpace.Initial;
    }

    @Override
    public PacketProcessor.ProcessResult accept(PacketProcessor processor, Instant time) {
        return processor.process(this, time);
    }

    @Override
    protected void checkPacketType(byte type) {
        byte masked = (byte)(type & 0xF0);
        if (masked != -64) {
            throw new RuntimeException();
        }
    }

    @Override
    protected void parseAdditionalFields(ByteBuffer buffer) throws InvalidPacketException {
        block3: {
            try {
                long tokenLength = VariableLengthInteger.parseLong(buffer);
                if (tokenLength <= 0L) break block3;
                if (tokenLength <= (long)buffer.remaining()) {
                    this.token = new byte[(int)tokenLength];
                    buffer.get(this.token);
                    break block3;
                }
                throw new InvalidPacketException();
            }
            catch (InvalidIntegerEncodingException e) {
                throw new InvalidPacketException();
            }
        }
    }

    public byte[] getToken() {
        return this.token;
    }

    @Override
    public String toString() {
        return "Packet " + (this.isProbe ? "P" : "") + this.getEncryptionLevel().name().charAt(0) + "|" + (Serializable)(this.packetNumber >= 0L ? Long.valueOf(this.packetNumber) : ".") + "|L|" + (Serializable)(this.packetSize >= 0 ? Integer.valueOf(this.packetSize) : ".") + "|" + this.frames.size() + "  Token=" + (this.token != null ? ByteUtils.bytesToHex(this.token) : "[]") + " " + this.frames.stream().map(f -> f.toString()).collect(Collectors.joining(" "));
    }

    public void ensureSize(int minimumSize) {
        int payloadSize;
        int estimatedPacketLength = 6 + this.destinationConnectionId.length + this.sourceConnectionId.length + (this.token != null ? this.token.length : 1) + 2 + 1 + (payloadSize = this.frames.stream().mapToInt(f -> f.getBytes().length).sum()) + 16;
        int paddingSize = minimumSize - estimatedPacketLength;
        if (paddingSize > 0) {
            this.frames.add(new Padding(paddingSize));
        }
    }
}

