/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.luminis.quic.io.LimitExceededException;

public class LimitedInputStream
extends FilterInputStream {
    private final long limit;
    private long bytesRead;

    public LimitedInputStream(InputStream in, long limit) {
        super(in);
        this.limit = limit;
    }

    @Override
    public int read() throws IOException {
        if (this.bytesRead < this.limit) {
            int read = super.read();
            ++this.bytesRead;
            return read;
        }
        throw new LimitExceededException(this.limit);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return super.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bytesRead < this.limit) {
            int read = super.read(b, off, (int)Long.min(this.limit - this.bytesRead, len));
            this.bytesRead += (long)read;
            return read;
        }
        throw new LimitExceededException(this.limit);
    }
}

