/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.Version;
import net.luminis.quic.frame.FrameProcessor3;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.frame.StreamType;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;
import net.luminis.quic.stream.StreamElement;

public class StreamFrame
extends QuicFrame
implements StreamElement,
Comparable<StreamElement> {
    private StreamType streamType;
    private int streamId;
    private int offset;
    private int length;
    private byte[] streamData;
    private boolean isFinal;
    private byte[] frameData;

    public StreamFrame() {
    }

    public StreamFrame(int streamId, byte[] applicationData, boolean fin) {
        this(Version.getDefault(), streamId, 0, applicationData, 0, applicationData.length, fin);
    }

    public StreamFrame(int streamId, int offset, byte[] applicationData, boolean fin) {
        this(Version.getDefault(), streamId, offset, applicationData, 0, applicationData.length, fin);
    }

    public StreamFrame(Version quicVersion, int streamId, int offset, byte[] applicationData, boolean fin) {
        this(quicVersion, streamId, offset, applicationData, 0, applicationData.length, fin);
    }

    public StreamFrame(int streamId, int offset, byte[] applicationData, int dataOffset, int dataLength, boolean fin) {
        this(Version.getDefault(), streamId, offset, applicationData, dataOffset, dataLength, fin);
    }

    public StreamFrame(Version quicVersion, int streamId, int streamOffset, byte[] applicationData, int dataOffset, int dataLength, boolean fin) {
        this.streamType = Stream.of(StreamType.values()).filter(t -> t.value == (streamId & 3)).findFirst().get();
        this.streamId = streamId;
        this.offset = streamOffset;
        this.streamData = new byte[dataLength];
        ByteBuffer.wrap(this.streamData).put(applicationData, dataOffset, dataLength);
        this.length = dataLength;
        this.isFinal = fin;
        ByteBuffer buffer = ByteBuffer.allocate(13 + applicationData.length);
        int baseType = 8;
        byte frameType = (byte)(baseType | 4 | 2 | 0);
        if (fin) {
            frameType = (byte)(frameType | 1);
        }
        buffer.put(frameType);
        VariableLengthInteger.encode(streamId, buffer);
        VariableLengthInteger.encode(this.offset, buffer);
        VariableLengthInteger.encode(this.length, buffer);
        buffer.put(applicationData, dataOffset, dataLength);
        this.frameData = new byte[buffer.position()];
        buffer.rewind();
        buffer.get(this.frameData);
    }

    public StreamFrame parse(ByteBuffer buffer, Logger log) throws InvalidIntegerEncodingException {
        byte frameType = buffer.get();
        boolean withOffset = (frameType & 4) == 4;
        boolean withLength = (frameType & 2) == 2;
        this.isFinal = (frameType & 1) == 1;
        this.streamId = VariableLengthInteger.parse(buffer);
        this.streamType = Stream.of(StreamType.values()).filter(t -> t.value == (this.streamId & 3)).findFirst().get();
        if (withOffset) {
            this.offset = VariableLengthInteger.parse(buffer);
        }
        this.length = withLength ? VariableLengthInteger.parse(buffer) : buffer.limit() - buffer.position();
        this.streamData = new byte[this.length];
        buffer.get(this.streamData);
        log.decrypted("Stream data", this.streamData);
        return this;
    }

    @Override
    public byte[] getBytes() {
        return this.frameData;
    }

    public String toString() {
        return "StreamFrame[" + this.streamId + "(" + this.streamType.abbrev + ")," + this.offset + "," + this.length + (this.isFinal ? ",f" : "") + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StreamFrame)) {
            return false;
        }
        StreamFrame that = (StreamFrame)o;
        return this.streamId == that.streamId && this.offset == that.offset && this.length == that.length && this.isFinal == that.isFinal && Arrays.equals(this.streamData, that.streamData);
    }

    public int hashCode() {
        return Objects.hash(this.streamId, this.offset, this.length);
    }

    @Override
    public int compareTo(StreamElement other) {
        if (this.offset != other.getOffset()) {
            return Integer.compare(this.offset, other.getOffset());
        }
        return Integer.compare(this.length, other.getLength());
    }

    public int getStreamId() {
        return this.streamId;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public byte[] getStreamData() {
        return this.streamData;
    }

    @Override
    public int getUpToOffset() {
        return this.offset + this.length;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public static int maxOverhead() {
        return 13;
    }

    @Override
    public void accept(FrameProcessor3 frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }
}

