/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.nio.ByteBuffer;
import java.time.Instant;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.Version;
import net.luminis.quic.frame.FrameProcessor3;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;

public class StopSendingFrame
extends QuicFrame {
    private int streamId;
    private int errorCode;

    public StopSendingFrame(Version quicVersion) {
    }

    public StopSendingFrame(Version quicVersion, Integer streamId, Integer errorCode) {
        this.streamId = streamId;
        this.errorCode = errorCode;
    }

    @Override
    public byte[] getBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(20);
        buffer.put((byte)5);
        VariableLengthInteger.encode(this.streamId, buffer);
        VariableLengthInteger.encode(this.errorCode, buffer);
        byte[] frameBytes = new byte[buffer.position()];
        buffer.flip();
        buffer.get(frameBytes);
        return frameBytes;
    }

    public StopSendingFrame parse(ByteBuffer buffer, Logger log) throws InvalidIntegerEncodingException {
        buffer.get();
        this.streamId = VariableLengthInteger.parse(buffer);
        this.errorCode = VariableLengthInteger.parse(buffer);
        return this;
    }

    public String toString() {
        return "StopSendingFrame[" + this.streamId + ":" + this.errorCode + "]";
    }

    @Override
    public void accept(FrameProcessor3 frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }

    public int getStreamId() {
        return this.streamId;
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

