/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.nio.ByteBuffer;
import java.time.Instant;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.frame.FrameProcessor3;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;

public class ResetStreamFrame
extends QuicFrame {
    private int streamId;
    private int errorCode;
    private long finalSize;

    public static int getMaximumFrameSize(int streamId, int errorCode) {
        int maxFinalSizeLength = 8;
        return 1 + VariableLengthInteger.bytesNeeded(streamId) + VariableLengthInteger.bytesNeeded(errorCode) + maxFinalSizeLength;
    }

    public ResetStreamFrame() {
    }

    public ResetStreamFrame(int streamId, int errorCode, long finalSize) {
        this.streamId = streamId;
        this.errorCode = errorCode;
        this.finalSize = finalSize;
    }

    @Override
    public byte[] getBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(25);
        buffer.put((byte)4);
        VariableLengthInteger.encode(this.streamId, buffer);
        VariableLengthInteger.encode(this.errorCode, buffer);
        VariableLengthInteger.encode(this.finalSize, buffer);
        byte[] frameBytes = new byte[buffer.position()];
        buffer.flip();
        buffer.get(frameBytes);
        return frameBytes;
    }

    public ResetStreamFrame parse(ByteBuffer buffer, Logger log) throws InvalidIntegerEncodingException {
        byte frameType = buffer.get();
        this.streamId = VariableLengthInteger.parse(buffer);
        this.errorCode = VariableLengthInteger.parse(buffer);
        this.finalSize = VariableLengthInteger.parse(buffer);
        return this;
    }

    public String toString() {
        return "ResetStreamFrame[" + this.streamId + "|" + this.errorCode + "|" + this.finalSize + "]";
    }

    @Override
    public void accept(FrameProcessor3 frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }

    public int getStreamId() {
        return this.streamId;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public long getFinalSize() {
        return this.finalSize;
    }
}

