/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.nio.ByteBuffer;
import java.time.Instant;
import net.luminis.quic.Version;
import net.luminis.quic.frame.FrameProcessor3;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;
import net.luminis.tls.util.ByteUtils;

public class PathResponseFrame
extends QuicFrame {
    private byte[] data;

    public PathResponseFrame(Version quicVersion, byte[] data) {
        if (data.length != 8) {
            throw new IllegalArgumentException("Path Response Frame must contain 8 bytes data");
        }
        this.data = data;
    }

    public PathResponseFrame(Version quicVersion) {
    }

    @Override
    public byte[] getBytes() {
        byte[] frameBytes = new byte[9];
        frameBytes[0] = 27;
        System.arraycopy(this.data, 0, frameBytes, 1, 8);
        return frameBytes;
    }

    public PathResponseFrame parse(ByteBuffer buffer, Logger log) {
        buffer.get();
        this.data = new byte[8];
        buffer.get(this.data);
        return this;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return "PathResponseFrame[" + ByteUtils.bytesToHex(this.data) + "]";
    }

    @Override
    public void accept(FrameProcessor3 frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }
}

