/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.nio.ByteBuffer;
import java.time.Instant;
import net.luminis.quic.Version;
import net.luminis.quic.frame.FrameProcessor3;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;
import net.luminis.tls.util.ByteUtils;

public class PathChallengeFrame
extends QuicFrame {
    private byte[] data;

    public PathChallengeFrame(Version quicVersion) {
    }

    public PathChallengeFrame parse(ByteBuffer buffer, Logger log) {
        byte frameType = buffer.get();
        if (frameType != 26) {
            throw new RuntimeException();
        }
        this.data = new byte[8];
        buffer.get(this.data);
        return this;
    }

    @Override
    public byte[] getBytes() {
        byte[] frameBytes = new byte[9];
        frameBytes[0] = 26;
        System.arraycopy(this.data, 0, frameBytes, 1, 8);
        return frameBytes;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return "PathChallengeFrame[" + ByteUtils.bytesToHex(this.data) + "]";
    }

    @Override
    public void accept(FrameProcessor3 frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }
}

