/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.nio.ByteBuffer;
import java.time.Instant;
import net.luminis.quic.frame.FrameProcessor3;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;

public class Padding
extends QuicFrame {
    private int length;

    public Padding() {
    }

    public Padding(int paddingSize) {
        this.length = paddingSize;
    }

    public Padding parse(ByteBuffer buffer, Logger log) {
        byte lastByte = 0;
        while (buffer.position() < buffer.limit() && (lastByte = buffer.get()) == 0) {
            ++this.length;
        }
        if (lastByte != 0) {
            buffer.position(buffer.position() - 1);
        }
        return this;
    }

    @Override
    public byte[] getBytes() {
        return new byte[this.length];
    }

    @Override
    public boolean isAckEliciting() {
        return false;
    }

    public String toString() {
        return "Padding(" + this.length + ")";
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public void accept(FrameProcessor3 frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }
}

