/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.nio.ByteBuffer;
import java.time.Instant;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.frame.FrameProcessor3;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;
import net.luminis.tls.util.ByteUtils;

public class NewTokenFrame
extends QuicFrame {
    private byte[] newToken;

    @Override
    public byte[] getBytes() {
        return new byte[0];
    }

    public NewTokenFrame parse(ByteBuffer buffer, Logger log) throws InvalidIntegerEncodingException {
        buffer.get();
        int tokenLength = VariableLengthInteger.parse(buffer);
        this.newToken = new byte[tokenLength];
        buffer.get(this.newToken);
        log.debug("Got New Token: ", this.newToken);
        return this;
    }

    public String toString() {
        return "NewTokenFrame[" + ByteUtils.bytesToHex(this.newToken) + "]";
    }

    @Override
    public void accept(FrameProcessor3 frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }

    public byte[] getToken() {
        return this.newToken;
    }
}

