/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Random;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.Version;
import net.luminis.quic.frame.FrameProcessor3;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;

public class NewConnectionIdFrame
extends QuicFrame {
    private Version quicVersion;
    private int sequenceNr;
    private int retirePriorTo;
    private byte[] connectionId;
    private static Random random = new Random();

    public NewConnectionIdFrame(Version quicVersion) {
        this.quicVersion = quicVersion;
    }

    public NewConnectionIdFrame(Version quicVersion, int sequenceNr, int retirePriorTo, byte[] newSourceConnectionId) {
        this.quicVersion = quicVersion;
        this.sequenceNr = sequenceNr;
        this.retirePriorTo = retirePriorTo;
        this.connectionId = newSourceConnectionId;
    }

    @Override
    public byte[] getBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(30);
        buffer.put((byte)24);
        VariableLengthInteger.encode(this.sequenceNr, buffer);
        VariableLengthInteger.encode(this.retirePriorTo, buffer);
        buffer.put((byte)this.connectionId.length);
        buffer.put(this.connectionId);
        random.ints(16L).forEach(i -> buffer.put((byte)i));
        byte[] bytes = new byte[buffer.position()];
        buffer.flip();
        buffer.get(bytes);
        return bytes;
    }

    public NewConnectionIdFrame parse(ByteBuffer buffer, Logger log) throws InvalidIntegerEncodingException {
        buffer.get();
        this.sequenceNr = VariableLengthInteger.parse(buffer);
        this.retirePriorTo = VariableLengthInteger.parse(buffer);
        byte connectionIdLength = buffer.get();
        this.connectionId = new byte[connectionIdLength];
        buffer.get(this.connectionId);
        byte[] statelessResetToken = new byte[16];
        buffer.get(statelessResetToken);
        return this;
    }

    public String toString() {
        return "NewConnectionIdFrame[" + this.sequenceNr + "," + this.retirePriorTo + "]";
    }

    public int getSequenceNr() {
        return this.sequenceNr;
    }

    public byte[] getConnectionId() {
        return this.connectionId;
    }

    public int getRetirePriorTo() {
        return this.retirePriorTo;
    }

    @Override
    public void accept(FrameProcessor3 frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }
}

