/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.nio.ByteBuffer;
import java.time.Instant;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.frame.FrameProcessor3;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;

public class MaxStreamDataFrame
extends QuicFrame {
    private int streamId;
    private long maxData;

    public MaxStreamDataFrame() {
    }

    public MaxStreamDataFrame(int stream, long maxData) {
        this.streamId = stream;
        this.maxData = maxData;
    }

    public MaxStreamDataFrame parse(ByteBuffer buffer, Logger log) throws InvalidIntegerEncodingException {
        buffer.get();
        this.streamId = VariableLengthInteger.parse(buffer);
        this.maxData = VariableLengthInteger.parse(buffer);
        return this;
    }

    public String toString() {
        return "MaxStreamDataFrame[" + this.streamId + ":" + this.maxData + "]";
    }

    @Override
    public byte[] getBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(17);
        buffer.put((byte)17);
        VariableLengthInteger.encode(this.streamId, buffer);
        VariableLengthInteger.encode(this.maxData, buffer);
        byte[] bytes = new byte[buffer.position()];
        buffer.flip();
        buffer.get(bytes);
        return bytes;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public long getMaxData() {
        return this.maxData;
    }

    @Override
    public void accept(FrameProcessor3 frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }
}

