/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.nio.ByteBuffer;
import java.time.Instant;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.frame.FrameProcessor3;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;

public class DataBlockedFrame
extends QuicFrame {
    private int streamDataLimit;

    public DataBlockedFrame() {
    }

    public DataBlockedFrame(int streamDataLimit) {
        this.streamDataLimit = streamDataLimit;
    }

    public DataBlockedFrame parse(ByteBuffer buffer, Logger log) throws InvalidIntegerEncodingException {
        byte frameType = buffer.get();
        this.streamDataLimit = VariableLengthInteger.parse(buffer);
        return this;
    }

    @Override
    public byte[] getBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(1 + VariableLengthInteger.bytesNeeded(this.streamDataLimit));
        buffer.put((byte)20);
        VariableLengthInteger.encode(this.streamDataLimit, buffer);
        return buffer.array();
    }

    public String toString() {
        return "DataBlockedFrame[" + this.streamDataLimit + "]";
    }

    @Override
    public void accept(FrameProcessor3 frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }
}

