/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.nio.ByteBuffer;
import java.time.Instant;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.Version;
import net.luminis.quic.frame.FrameProcessor3;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;
import net.luminis.quic.stream.StreamElement;

public class CryptoFrame
extends QuicFrame
implements StreamElement,
Comparable<StreamElement> {
    private int offset;
    private int length;
    private byte[] cryptoData;
    private byte[] bytes;

    public CryptoFrame(Version quicVersion, int offset, byte[] payload) {
        this.offset = offset;
        this.cryptoData = payload;
        this.length = payload.length;
        ByteBuffer frameBuffer = ByteBuffer.allocate(12 + payload.length);
        VariableLengthInteger.encode(6, frameBuffer);
        VariableLengthInteger.encode(offset, frameBuffer);
        VariableLengthInteger.encode(payload.length, frameBuffer);
        frameBuffer.put(payload);
        this.bytes = new byte[frameBuffer.position()];
        frameBuffer.rewind();
        frameBuffer.get(this.bytes);
    }

    public CryptoFrame() {
    }

    public CryptoFrame(Version quicVersion, byte[] payload) {
        this(quicVersion, 0, payload);
    }

    public CryptoFrame parse(ByteBuffer buffer, Logger log) throws InvalidIntegerEncodingException {
        log.debug("Parsing Crypto frame");
        buffer.get();
        this.offset = VariableLengthInteger.parse(buffer);
        this.length = VariableLengthInteger.parse(buffer);
        this.cryptoData = new byte[this.length];
        buffer.get(this.cryptoData);
        log.decrypted("Crypto data [" + this.offset + "," + this.length + "]", this.cryptoData);
        return this;
    }

    public String toString() {
        return "CryptoFrame[" + this.offset + "," + this.length + "]";
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public byte[] getStreamData() {
        return this.cryptoData;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getUpToOffset() {
        return this.offset + this.length;
    }

    @Override
    public int compareTo(StreamElement other) {
        if (this.offset != other.getOffset()) {
            return Integer.compare(this.offset, other.getOffset());
        }
        return Integer.compare(this.length, other.getLength());
    }

    @Override
    public void accept(FrameProcessor3 frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }
}

