/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.Version;
import net.luminis.quic.frame.FrameProcessor3;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;

public class ConnectionCloseFrame
extends QuicFrame {
    private int errorCode;
    private int triggeringFrameType;
    private byte[] reasonPhrase = new byte[0];
    private int tlsError = -1;
    private int frameType = 28;

    public ConnectionCloseFrame(Version quicVersion) {
        this.errorCode = 0;
    }

    public ConnectionCloseFrame(Version quicVersion, int error, String reason) {
        this.errorCode = error;
        if (reason != null && !reason.isBlank()) {
            this.reasonPhrase = reason.getBytes(StandardCharsets.UTF_8);
        }
    }

    public ConnectionCloseFrame parse(ByteBuffer buffer, Logger log) throws InvalidIntegerEncodingException {
        int reasonPhraseLength;
        this.frameType = buffer.get() & 0xFF;
        if (this.frameType != 28 && this.frameType != 29) {
            throw new RuntimeException();
        }
        this.errorCode = VariableLengthInteger.parse(buffer);
        if (this.frameType == 28) {
            this.triggeringFrameType = VariableLengthInteger.parse(buffer);
        }
        if ((reasonPhraseLength = VariableLengthInteger.parse(buffer)) > 0) {
            this.reasonPhrase = new byte[reasonPhraseLength];
            buffer.get(this.reasonPhrase);
        }
        if (this.errorCode > 256) {
            this.tlsError = this.errorCode - 256;
        }
        return this;
    }

    public boolean hasTransportError() {
        return this.frameType == 28 && this.errorCode != 0;
    }

    public boolean hasTlsError() {
        return this.errorCode >= 256 && this.errorCode < 512;
    }

    public long getTlsError() {
        if (this.hasTlsError()) {
            return this.errorCode - 256;
        }
        throw new IllegalStateException("Close does not have a TLS error");
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public boolean hasReasonPhrase() {
        return this.reasonPhrase != null;
    }

    public String getReasonPhrase() {
        try {
            return new String(this.reasonPhrase, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public boolean hasApplicationProtocolError() {
        return this.frameType == 29 && this.errorCode != 0;
    }

    public boolean hasError() {
        return this.hasTransportError() || this.hasApplicationProtocolError();
    }

    @Override
    public byte[] getBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        buffer.put((byte)28);
        VariableLengthInteger.encode(this.errorCode, buffer);
        VariableLengthInteger.encode(0, buffer);
        VariableLengthInteger.encode(this.reasonPhrase.length, buffer);
        buffer.put(this.reasonPhrase);
        byte[] bytes = new byte[buffer.position()];
        buffer.flip();
        buffer.get(bytes);
        return bytes;
    }

    @Override
    public boolean isAckEliciting() {
        return false;
    }

    public String toString() {
        return "ConnectionCloseFrame[" + (Serializable)(this.tlsError >= 0 ? "TLS " + this.tlsError : Integer.valueOf(this.errorCode)) + "|" + this.triggeringFrameType + "|" + (this.reasonPhrase != null ? new String(this.reasonPhrase) : "-") + "]";
    }

    @Override
    public void accept(FrameProcessor3 frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }
}

