/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.frame;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.Version;
import net.luminis.quic.frame.FrameProcessor3;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;

public class AckFrame
extends QuicFrame {
    public static final int MAX_FRAME_SIZE = 1000;
    private byte[] frameBytes;
    private long largestAcknowledged;
    private int ackDelay;
    private List<Long> acknowledgedPacketNumbers;
    private int delayScale = 8;
    private String stringRepresentation = "";

    public AckFrame() {
    }

    public AckFrame(long packetNumber) {
        this(Version.getDefault(), packetNumber);
    }

    public AckFrame(Version quicVersion, long packetNumber) {
        this.largestAcknowledged = (int)packetNumber;
        this.acknowledgedPacketNumbers = List.of(Long.valueOf(this.largestAcknowledged));
        this.stringRepresentation = String.valueOf(this.largestAcknowledged);
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        buffer.put((byte)2);
        VariableLengthInteger.encode(packetNumber, buffer);
        VariableLengthInteger.encode(0, buffer);
        VariableLengthInteger.encode(0, buffer);
        VariableLengthInteger.encode(0, buffer);
        this.frameBytes = new byte[buffer.position()];
        buffer.flip();
        buffer.get(this.frameBytes);
    }

    public AckFrame(List<Long> packetNumbers) {
        this(Version.getDefault(), packetNumbers);
    }

    public AckFrame(Version quicVersion, List<Long> packetNumbers) {
        this(quicVersion, packetNumbers, 0);
    }

    public AckFrame(Version quicVersion, List<Long> packetNumbers, int ackDelay) {
        this.ackDelay = ackDelay * 1000 / this.delayScale;
        if (packetNumbers.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.acknowledgedPacketNumbers = packetNumbers.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        this.largestAcknowledged = this.acknowledgedPacketNumbers.get(0);
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        buffer.put((byte)2);
        VariableLengthInteger.encode(this.largestAcknowledged, buffer);
        VariableLengthInteger.encode(ackDelay, buffer);
        ArrayList<List<Long>> ranges = this.split(this.acknowledgedPacketNumbers);
        VariableLengthInteger.encode(ranges.size() - 1, buffer);
        VariableLengthInteger.encode(ranges.get(0).size() - 1, buffer);
        for (int i = 1; i < ranges.size(); ++i) {
            long prev = AckFrame.getLastElement(ranges.get(i - 1));
            long next = ranges.get(i).get(0);
            int gap = (int)(prev - next - 2L);
            int block = ranges.get(i).size() - 1;
            VariableLengthInteger.encode(gap, buffer);
            VariableLengthInteger.encode(block, buffer);
        }
        this.stringRepresentation = !ranges.isEmpty() ? ranges.stream().map(range -> range.size() == 1 ? ((Long)range.get(0)).toString() : ((Long)range.get(0)).toString() + "-" + ((Long)range.get(range.size() - 1)).toString()).collect(Collectors.joining(",")) : String.valueOf(this.largestAcknowledged);
        this.frameBytes = new byte[buffer.position()];
        buffer.flip();
        buffer.get(this.frameBytes);
    }

    private ArrayList<List<Long>> split(List<Long> packetNumbers) {
        return packetNumbers.stream().collect(ArrayList::new, (result, element) -> {
            if (result.isEmpty()) {
                result.add(new ArrayList());
                ((List)AckFrame.getLastElement(result)).add(element);
            } else if ((Long)AckFrame.getLastElement((List)AckFrame.getLastElement(result)) == element + 1L) {
                ((List)AckFrame.getLastElement(result)).add(element);
            } else {
                result.add(new ArrayList());
                ((List)AckFrame.getLastElement(result)).add(element);
            }
        }, ArrayList::addAll);
    }

    private static <E> E getLastElement(List<E> list) {
        return list.get(list.size() - 1);
    }

    public AckFrame parse(ByteBuffer buffer, Logger log) throws InvalidIntegerEncodingException {
        log.debug("Parsing AckFrame");
        this.acknowledgedPacketNumbers = new ArrayList<Long>();
        buffer.get();
        this.largestAcknowledged = VariableLengthInteger.parseLong(buffer);
        this.ackDelay = (int)VariableLengthInteger.parseLong(buffer);
        int ackBlockCount = (int)VariableLengthInteger.parseLong(buffer);
        long currentSmallest = this.largestAcknowledged;
        currentSmallest -= (long)(this.addAcknowledgeRange(this.largestAcknowledged, 1 + VariableLengthInteger.parse(buffer)) - 1);
        for (int i = 0; i < ackBlockCount; ++i) {
            int gapSize = VariableLengthInteger.parse(buffer) + 1;
            int contiguousPacketsPreceding = VariableLengthInteger.parse(buffer) + 1;
            currentSmallest -= (long)(gapSize + this.addAcknowledgeRange(currentSmallest - (long)gapSize - 1L, contiguousPacketsPreceding));
        }
        return this;
    }

    private int addAcknowledgeRange(long largestOfRange, int rangeSize) {
        for (int i = 0; i < rangeSize; ++i) {
            this.acknowledgedPacketNumbers.add(largestOfRange - (long)i);
        }
        if (!this.stringRepresentation.isEmpty()) {
            this.stringRepresentation = this.stringRepresentation + ",";
        }
        this.stringRepresentation = this.stringRepresentation + (Serializable)(rangeSize > 1 ? largestOfRange + "-" + (largestOfRange - (long)rangeSize + 1L) : Long.valueOf(largestOfRange));
        return rangeSize;
    }

    public List<Long> getAckedPacketNumbers() {
        return this.acknowledgedPacketNumbers;
    }

    public String toString() {
        return "AckFrame[" + this.stringRepresentation + "|\u0394" + this.ackDelay * this.delayScale / 1000 + "]";
    }

    @Override
    public byte[] getBytes() {
        return this.frameBytes;
    }

    @Override
    public boolean isAckEliciting() {
        return false;
    }

    public long getLargestAcknowledged() {
        return this.largestAcknowledged;
    }

    public int getAckDelay() {
        return this.ackDelay * this.delayScale / 1000;
    }

    public void setDelayExponent(int exponent) {
        this.delayScale = (int)Math.pow(2.0, exponent);
    }

    @Override
    public void accept(FrameProcessor3 frameProcessor, QuicPacket packet, Instant timeReceived) {
        frameProcessor.process(this, packet, timeReceived);
    }
}

