/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.crypto;

import at.favre.lib.crypto.HKDF;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import net.luminis.quic.EncryptionLevel;
import net.luminis.quic.Role;
import net.luminis.quic.Version;
import net.luminis.quic.crypto.Chacha20Keys;
import net.luminis.quic.crypto.Keys;
import net.luminis.quic.log.Logger;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.TrafficSecrets;
import net.luminis.tls.util.ByteUtils;

public class ConnectionSecrets {
    private TlsConstants.CipherSuite selectedCipherSuite;
    public static final byte[] STATIC_SALT_DRAFT_29 = new byte[]{-81, -65, -20, 40, -103, -109, -46, 76, -98, -105, -122, -15, -100, 97, 17, -32, 67, -112, -88, -103};
    public static final byte[] STATIC_SALT_V1 = new byte[]{56, 118, 44, -9, -11, 89, 52, -77, 77, 23, -102, -26, -92, -56, 12, -83, -52, -69, 127, 10};
    private final Version quicVersion;
    private final Role ownRole;
    private Logger log;
    private byte[] clientRandom;
    private Keys[] clientSecrets = new Keys[EncryptionLevel.values().length];
    private Keys[] serverSecrets = new Keys[EncryptionLevel.values().length];
    private boolean writeSecretsToFile;
    private Path wiresharkSecretsFile;

    public ConnectionSecrets(Version quicVersion, Role role, Path wiresharksecrets, Logger log) {
        this.quicVersion = quicVersion;
        this.ownRole = role;
        this.log = log;
        if (wiresharksecrets != null) {
            this.wiresharkSecretsFile = wiresharksecrets;
            try {
                Files.deleteIfExists(this.wiresharkSecretsFile);
                Files.createFile(this.wiresharkSecretsFile, new FileAttribute[0]);
                this.writeSecretsToFile = true;
            }
            catch (IOException e) {
                log.error("Initializing (creating/truncating) secrets file '" + this.wiresharkSecretsFile + "' failed", e);
            }
        }
    }

    public synchronized void computeInitialKeys(byte[] destConnectionId) {
        HKDF hkdf = HKDF.fromHmacSha256();
        byte[] initialSalt = this.quicVersion == Version.QUIC_version_1 ? STATIC_SALT_V1 : STATIC_SALT_DRAFT_29;
        byte[] initialSecret = hkdf.extract(initialSalt, destConnectionId);
        this.log.secret("Initial secret", initialSecret);
        this.clientSecrets[EncryptionLevel.Initial.ordinal()] = new Keys(this.quicVersion, initialSecret, Role.Client, this.log);
        this.serverSecrets[EncryptionLevel.Initial.ordinal()] = new Keys(this.quicVersion, initialSecret, Role.Server, this.log);
    }

    public synchronized void computeEarlySecrets(TrafficSecrets secrets) {
        Keys zeroRttSecrets = new Keys(this.quicVersion, Role.Client, this.log);
        zeroRttSecrets.computeZeroRttKeys(secrets);
        this.clientSecrets[EncryptionLevel.ZeroRTT.ordinal()] = zeroRttSecrets;
    }

    private void createKeys(EncryptionLevel level, TlsConstants.CipherSuite selectedCipherSuite) {
        Keys serverHandshakeSecrets;
        Keys clientHandshakeSecrets;
        if (selectedCipherSuite == TlsConstants.CipherSuite.TLS_AES_128_GCM_SHA256) {
            clientHandshakeSecrets = new Keys(this.quicVersion, Role.Client, this.log);
            serverHandshakeSecrets = new Keys(this.quicVersion, Role.Server, this.log);
        } else if (selectedCipherSuite == TlsConstants.CipherSuite.TLS_CHACHA20_POLY1305_SHA256) {
            clientHandshakeSecrets = new Chacha20Keys(this.quicVersion, Role.Client, this.log);
            serverHandshakeSecrets = new Chacha20Keys(this.quicVersion, Role.Server, this.log);
        } else {
            throw new IllegalStateException("unsupported cipher suite " + selectedCipherSuite);
        }
        this.clientSecrets[level.ordinal()] = clientHandshakeSecrets;
        this.serverSecrets[level.ordinal()] = serverHandshakeSecrets;
        clientHandshakeSecrets.setPeerKeys(serverHandshakeSecrets);
        serverHandshakeSecrets.setPeerKeys(clientHandshakeSecrets);
    }

    public synchronized void computeHandshakeSecrets(TrafficSecrets secrets, TlsConstants.CipherSuite selectedCipherSuite) {
        this.selectedCipherSuite = selectedCipherSuite;
        this.createKeys(EncryptionLevel.Handshake, selectedCipherSuite);
        this.clientSecrets[EncryptionLevel.Handshake.ordinal()].computeHandshakeKeys(secrets);
        this.serverSecrets[EncryptionLevel.Handshake.ordinal()].computeHandshakeKeys(secrets);
        if (this.writeSecretsToFile) {
            this.appendToFile("HANDSHAKE_TRAFFIC_SECRET", EncryptionLevel.Handshake);
        }
    }

    public synchronized void computeApplicationSecrets(TrafficSecrets secrets) {
        this.createKeys(EncryptionLevel.App, this.selectedCipherSuite);
        this.clientSecrets[EncryptionLevel.App.ordinal()].computeApplicationKeys(secrets);
        this.serverSecrets[EncryptionLevel.App.ordinal()].computeApplicationKeys(secrets);
        if (this.writeSecretsToFile) {
            this.appendToFile("TRAFFIC_SECRET_0", EncryptionLevel.App);
        }
    }

    private void appendToFile(String label, EncryptionLevel level) {
        ArrayList<CallSite> content = new ArrayList<CallSite>();
        content.add((CallSite)((Object)("CLIENT_" + label + " " + ByteUtils.bytesToHex(this.clientRandom) + " " + ByteUtils.bytesToHex(this.clientSecrets[level.ordinal()].getTrafficSecret()))));
        content.add((CallSite)((Object)("SERVER_" + label + " " + ByteUtils.bytesToHex(this.clientRandom) + " " + ByteUtils.bytesToHex(this.serverSecrets[level.ordinal()].getTrafficSecret()))));
        try {
            Files.write(this.wiresharkSecretsFile, content, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            this.log.error("Writing secrets to file '" + this.wiresharkSecretsFile + "' failed", e);
            this.writeSecretsToFile = false;
        }
    }

    public void setClientRandom(byte[] clientRandom) {
        this.clientRandom = clientRandom;
    }

    public synchronized Keys getClientSecrets(EncryptionLevel encryptionLevel) {
        return this.clientSecrets[encryptionLevel.ordinal()];
    }

    public synchronized Keys getServerSecrets(EncryptionLevel encryptionLevel) {
        return this.serverSecrets[encryptionLevel.ordinal()];
    }

    public synchronized Keys getPeerSecrets(EncryptionLevel encryptionLevel) {
        return this.ownRole == Role.Client ? this.serverSecrets[encryptionLevel.ordinal()] : this.clientSecrets[encryptionLevel.ordinal()];
    }

    public synchronized Keys getOwnSecrets(EncryptionLevel encryptionLevel) {
        return this.ownRole == Role.Client ? this.clientSecrets[encryptionLevel.ordinal()] : this.serverSecrets[encryptionLevel.ordinal()];
    }
}

