/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.cid;

import java.util.List;
import java.util.stream.Collectors;
import net.luminis.quic.cid.ConnectionIdInfo;
import net.luminis.quic.cid.ConnectionIdRegistry;
import net.luminis.quic.cid.ConnectionIdStatus;
import net.luminis.quic.log.Logger;

public class DestinationConnectionIdRegistry
extends ConnectionIdRegistry {
    private final byte[] originalConnectionId;
    private volatile int notRetiredThreshold;
    private volatile byte[] retrySourceConnectionId;

    public DestinationConnectionIdRegistry(Logger log) {
        super(log);
        this.originalConnectionId = this.currentConnectionId;
    }

    public DestinationConnectionIdRegistry(byte[] initialConnectionId, Logger log) {
        super(log);
        this.originalConnectionId = initialConnectionId;
        this.currentConnectionId = initialConnectionId;
        this.connectionIds.put(0, new ConnectionIdInfo(0, initialConnectionId, ConnectionIdStatus.IN_USE));
    }

    public void replaceInitialConnectionId(byte[] connectionId) {
        this.connectionIds.put(0, new ConnectionIdInfo(0, connectionId, ConnectionIdStatus.IN_USE));
        this.currentConnectionId = connectionId;
    }

    public boolean registerNewConnectionId(int sequenceNr, byte[] connectionId) {
        if (sequenceNr >= this.notRetiredThreshold) {
            this.connectionIds.put(sequenceNr, new ConnectionIdInfo(sequenceNr, connectionId, ConnectionIdStatus.NEW));
            return true;
        }
        this.connectionIds.put(sequenceNr, new ConnectionIdInfo(sequenceNr, connectionId, ConnectionIdStatus.RETIRED));
        return false;
    }

    public byte[] useNext() {
        int currentIndex = this.currentIndex();
        if (this.connectionIds.containsKey(currentIndex + 1)) {
            this.currentConnectionId = ((ConnectionIdInfo)this.connectionIds.get(currentIndex + 1)).getConnectionId();
            ((ConnectionIdInfo)this.connectionIds.get(currentIndex)).setStatus(ConnectionIdStatus.USED);
            ((ConnectionIdInfo)this.connectionIds.get(currentIndex + 1)).setStatus(ConnectionIdStatus.IN_USE);
            return this.currentConnectionId;
        }
        return null;
    }

    public byte[] getOriginalConnectionId() {
        return this.originalConnectionId;
    }

    public List<Integer> retireAllBefore(int retirePriorTo) {
        this.notRetiredThreshold = retirePriorTo;
        int currentIndex = this.currentIndex();
        List<Integer> toRetire = this.connectionIds.entrySet().stream().filter(entry -> (Integer)entry.getKey() < retirePriorTo).filter(entry -> !((ConnectionIdInfo)entry.getValue()).getConnectionIdStatus().equals((Object)ConnectionIdStatus.RETIRED)).map(entry -> (Integer)entry.getKey()).collect(Collectors.toList());
        toRetire.forEach(seqNr -> this.retireConnectionId((int)seqNr));
        if (((ConnectionIdInfo)this.connectionIds.get(currentIndex)).getConnectionIdStatus().equals((Object)ConnectionIdStatus.RETIRED)) {
            ConnectionIdInfo nextCid = this.connectionIds.values().stream().filter(cid -> !cid.getConnectionIdStatus().equals((Object)ConnectionIdStatus.RETIRED)).findFirst().orElseThrow(() -> new IllegalStateException("Can't find connection id that is not retired"));
            nextCid.setStatus(ConnectionIdStatus.IN_USE);
            this.currentConnectionId = nextCid.getConnectionId();
        }
        return toRetire;
    }

    public byte[] getRetrySourceConnectionId() {
        return this.retrySourceConnectionId;
    }

    public void setRetrySourceConnectionId(byte[] retrySourceConnectionId) {
        this.retrySourceConnectionId = retrySourceConnectionId;
    }
}

