/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.cid;

import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.luminis.quic.cid.ConnectionIdInfo;
import net.luminis.quic.cid.ConnectionIdStatus;
import net.luminis.quic.log.Logger;

public abstract class ConnectionIdRegistry {
    public static final int DEFAULT_CID_LENGTH = 8;
    protected Map<Integer, ConnectionIdInfo> connectionIds = new ConcurrentHashMap<Integer, ConnectionIdInfo>();
    protected volatile byte[] currentConnectionId;
    protected final Logger log;
    private final Random random = new Random();
    private final int connectionIdLength;

    public ConnectionIdRegistry(Logger log) {
        this(8, log);
    }

    public ConnectionIdRegistry(Integer cidLength, Logger logger) {
        this.connectionIdLength = cidLength != null ? cidLength : 8;
        this.log = logger;
        this.currentConnectionId = this.generateConnectionId();
        this.connectionIds.put(0, new ConnectionIdInfo(0, this.currentConnectionId, ConnectionIdStatus.IN_USE));
    }

    public void retireConnectionId(int sequenceNr) {
        if (this.connectionIds.containsKey(sequenceNr)) {
            this.connectionIds.get(sequenceNr).setStatus(ConnectionIdStatus.RETIRED);
        }
    }

    public byte[] getCurrent() {
        return this.currentConnectionId;
    }

    public Map<Integer, ConnectionIdInfo> getAll() {
        return this.connectionIds;
    }

    protected int currentIndex() {
        return this.connectionIds.entrySet().stream().filter(entry -> ((ConnectionIdInfo)entry.getValue()).getConnectionId().equals(this.currentConnectionId)).mapToInt(entry -> (Integer)entry.getKey()).findFirst().orElseThrow();
    }

    protected byte[] generateConnectionId() {
        byte[] connectionId = new byte[this.connectionIdLength];
        this.random.nextBytes(connectionId);
        return connectionId;
    }

    public int getConnectionIdlength() {
        return this.connectionIdLength;
    }
}

