/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.cc;

import java.util.List;
import net.luminis.quic.cc.CongestionControlEventListener;
import net.luminis.quic.cc.CongestionController;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.PacketInfo;
import net.luminis.quic.packet.QuicPacket;

public class AbstractCongestionController
implements CongestionController {
    protected static final int initialWindowSize = 12000;
    protected final Logger log;
    protected volatile long bytesInFlight;
    protected volatile long congestionWindow;
    protected final CongestionControlEventListener eventListener;

    public AbstractCongestionController(Logger logger, CongestionControlEventListener eventListener) {
        this.log = logger;
        this.eventListener = eventListener;
        this.congestionWindow = 12000L;
    }

    @Override
    public synchronized void registerInFlight(QuicPacket sentPacket) {
        if (!sentPacket.isAckOnly()) {
            this.bytesInFlight += (long)sentPacket.getSize();
            this.eventListener.bytesInFlightIncreased(this.bytesInFlight);
            this.log.debug("Bytes in flight increased to " + this.bytesInFlight);
            if (this.bytesInFlight > this.congestionWindow) {
                this.log.cc("Bytes in flight exceeds congestion window: " + this.bytesInFlight + " > " + this.congestionWindow);
            }
        }
    }

    @Override
    public synchronized void registerAcked(List<? extends PacketInfo> acknowlegdedPackets) {
        int bytesInFlightAcked = acknowlegdedPackets.stream().map(packetInfo -> packetInfo.packet()).mapToInt(packet -> packet.getSize()).sum();
        if (bytesInFlightAcked > 0) {
            this.bytesInFlight -= (long)bytesInFlightAcked;
            this.eventListener.bytesInFlightDecreased(this.bytesInFlight);
            this.checkBytesInFlight();
            this.log.debug("Bytes in flight decreased to " + this.bytesInFlight + " (" + acknowlegdedPackets.size() + " packets acked)");
        }
    }

    @Override
    public synchronized void registerLost(List<? extends PacketInfo> lostPackets) {
        long lostBytes = lostPackets.stream().map(packetStatus -> packetStatus.packet()).mapToInt(packet -> packet.getSize()).sum();
        this.bytesInFlight -= lostBytes;
        this.eventListener.bytesInFlightDecreased(this.bytesInFlight);
        if (lostBytes > 0L) {
            this.checkBytesInFlight();
            this.log.debug("Bytes in flight decreased to " + this.bytesInFlight + " (" + lostPackets.size() + " packets lost)");
        }
    }

    @Override
    public synchronized void discard(List<? extends PacketInfo> discardedPackets) {
        long discardedBytes = discardedPackets.stream().map(packetStatus -> packetStatus.packet()).mapToInt(packet -> packet.getSize()).sum();
        this.bytesInFlight -= discardedBytes;
        this.eventListener.bytesInFlightDecreased(this.bytesInFlight);
        if (discardedBytes > 0L) {
            this.checkBytesInFlight();
            this.log.debug("Bytes in flight decreased with " + discardedBytes + " to " + this.bytesInFlight + " (" + discardedPackets.size() + " packets RESET)");
        }
    }

    @Override
    public synchronized boolean canSend(int bytes) {
        return this.bytesInFlight + (long)bytes < this.congestionWindow;
    }

    @Override
    public long getBytesInFlight() {
        return this.bytesInFlight;
    }

    @Override
    public long getWindowSize() {
        return this.congestionWindow;
    }

    @Override
    public long remainingCwnd() {
        return this.congestionWindow - this.bytesInFlight;
    }

    @Override
    public void reset() {
        this.log.debug("Resetting congestion controller.");
        this.bytesInFlight = 0L;
        this.eventListener.bytesInFlightDecreased(this.bytesInFlight);
    }

    private void checkBytesInFlight() {
        if (this.bytesInFlight < 0L) {
            this.log.error("Inconsistency error in congestion controller; attempt to set bytes in-flight below 0");
            this.bytesInFlight = 0L;
            this.eventListener.bytesInFlightDecreased(this.bytesInFlight);
        }
    }
}

