/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.stream.Stream;
import net.luminis.quic.UnknownVersionException;

public enum Version {
    GoogleQuic_44(1362113588),
    GoogleQuic_45(1362113589),
    reserved_1(438975050),
    IETF_draft_11(-16777205),
    IETF_draft_12(-16777204),
    IETF_draft_13(-16777203),
    IETF_draft_14(-16777202),
    IETF_draft_15(-16777201),
    IETF_draft_16(-16777200),
    IETF_draft_17(-16777199),
    IETF_draft_18(-16777198),
    IETF_draft_19(-16777197),
    IETF_draft_20(-16777196),
    IETF_draft_21(-16777195),
    IETF_draft_22(-16777194),
    IETF_draft_23(-16777193),
    IETF_draft_24(-16777192),
    IETF_draft_25(-16777191),
    IETF_draft_26(-16777190),
    IETF_draft_27(-16777189),
    IETF_draft_28(-16777188),
    IETF_draft_29(-16777187),
    IETF_draft_30(-16777186),
    IETF_draft_31(-16777185),
    IETF_draft_32(-16777184),
    QUIC_version_1(1);

    private int versionId;

    private Version(int versionId) {
        this.versionId = versionId;
    }

    public byte[] getBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(this.versionId);
        return buffer.array();
    }

    public static Version parse(int input) throws UnknownVersionException {
        Optional<Version> version = Stream.of(Version.values()).filter(candidate -> candidate.versionId == input).findFirst();
        return version.orElseThrow(() -> new UnknownVersionException());
    }

    public static Version getDefault() {
        return QUIC_version_1;
    }

    public boolean atLeast(Version other) {
        if (this.isIetfVersion(this) && this.isIetfVersion(other)) {
            return this.versionId >= other.versionId;
        }
        if (this.isReserved()) {
            return true;
        }
        throw new RuntimeException();
    }

    public boolean before(Version other) {
        if (this.isIetfVersion(this) && this.isIetfVersion(other)) {
            return this.versionId < other.versionId;
        }
        if (this.isReserved()) {
            return false;
        }
        throw new RuntimeException();
    }

    public boolean isReserved() {
        return this.equals((Object)reserved_1);
    }

    public String getDraftVersion() {
        if (this.name().startsWith("IETF_draft_")) {
            return this.name().substring("IETF_draft_".length());
        }
        return "";
    }

    private boolean isIetfVersion(Version version) {
        return version.versionId >= Version.IETF_draft_11.versionId && version.versionId <= Version.IETF_draft_32.versionId || version == QUIC_version_1;
    }

    public int getId() {
        return this.versionId;
    }
}

