/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.tls.util.ByteUtils;

public class VariableLengthInteger {
    public static int parse(ByteBuffer buffer) throws InvalidIntegerEncodingException {
        long value = VariableLengthInteger.parseLong(buffer);
        if (value <= Integer.MAX_VALUE) {
            return (int)value;
        }
        throw new IllegalArgumentException("value to large for Java int");
    }

    public static long parseLong(ByteBuffer buffer) throws InvalidIntegerEncodingException {
        long value;
        if (buffer.remaining() < 1) {
            throw new InvalidIntegerEncodingException();
        }
        byte firstLengthByte = buffer.get();
        switch ((firstLengthByte & 0xC0) >> 6) {
            case 0: {
                value = firstLengthByte;
                break;
            }
            case 1: {
                if (buffer.remaining() < 1) {
                    throw new InvalidIntegerEncodingException();
                }
                buffer.position(buffer.position() - 1);
                value = buffer.getShort() & 0x3FFF;
                break;
            }
            case 2: {
                if (buffer.remaining() < 3) {
                    throw new InvalidIntegerEncodingException();
                }
                buffer.position(buffer.position() - 1);
                value = buffer.getInt() & 0x3FFFFFFF;
                break;
            }
            case 3: {
                if (buffer.remaining() < 7) {
                    throw new InvalidIntegerEncodingException();
                }
                buffer.position(buffer.position() - 1);
                value = buffer.getLong() & 0x3FFFFFFFFFFFFFFFL;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return value;
    }

    public static int parse(InputStream inputStream) throws IOException {
        long value = VariableLengthInteger.parseLong(inputStream);
        if (value <= Integer.MAX_VALUE) {
            return (int)value;
        }
        throw new RuntimeException("value to large for Java int");
    }

    public static long parseLong(InputStream inputStream) throws IOException {
        long value;
        int firstLengthByte = inputStream.read();
        if (firstLengthByte == -1) {
            throw new EOFException();
        }
        switch ((firstLengthByte & 0xC0) >> 6) {
            case 0: {
                value = firstLengthByte;
                break;
            }
            case 1: {
                int nextByte = inputStream.read();
                if (nextByte == -1) {
                    throw new EOFException();
                }
                value = (firstLengthByte & 0x3F) << 8 | nextByte & 0xFF;
                break;
            }
            case 2: {
                int byte2 = inputStream.read();
                int byte3 = inputStream.read();
                int byte4 = inputStream.read();
                if (byte2 == -1 || byte3 == -1 || byte4 == -1) {
                    throw new EOFException();
                }
                value = (firstLengthByte & 0x3F) << 24 | (byte2 & 0xFF) << 16 | (byte3 & 0xFF) << 8 | byte4 & 0xFF;
                break;
            }
            case 3: {
                int read;
                byte[] rawBytes = new byte[8];
                rawBytes[0] = (byte)(firstLengthByte & 0x3F);
                for (int bytesRead = 0; bytesRead != 7; bytesRead += read) {
                    read = inputStream.read(rawBytes, 1 + bytesRead, 7 - bytesRead);
                    if (read > 0) {
                        continue;
                    }
                    throw new EOFException();
                }
                value = ByteBuffer.wrap(rawBytes).getLong();
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return value;
    }

    public static int bytesNeeded(long value) {
        if (value <= 63L) {
            return 1;
        }
        if (value <= 16383L) {
            return 2;
        }
        if (value <= 0x3FFFFFFFL) {
            return 4;
        }
        return 8;
    }

    public static int encode(int value, ByteBuffer buffer) {
        if (value <= 63) {
            buffer.put((byte)value);
            return 1;
        }
        if (value <= 16383) {
            buffer.put((byte)(value / 256 | 0x40));
            buffer.put((byte)(value % 256));
            return 2;
        }
        if (value <= 0x3FFFFFFF) {
            int initialPosition = buffer.position();
            buffer.putInt(value);
            buffer.put(initialPosition, (byte)(buffer.get(initialPosition) | 0xFFFFFF80));
            return 4;
        }
        int initialPosition = buffer.position();
        buffer.putLong(value);
        buffer.put(initialPosition, (byte)(buffer.get(initialPosition) | 0xFFFFFFC0));
        return 8;
    }

    public static int encode(long value, ByteBuffer buffer) {
        if (value <= Integer.MAX_VALUE) {
            return VariableLengthInteger.encode((int)value, buffer);
        }
        if (value <= 0x3FFFFFFFFFFFFFFFL) {
            int initialPosition = buffer.position();
            buffer.putLong(value);
            buffer.put(initialPosition, (byte)(buffer.get(initialPosition) | 0xFFFFFFC0));
            return 8;
        }
        throw new IllegalArgumentException("value cannot be encoded in variable-length integer");
    }

    public static void main(String[] args) throws InvalidIntegerEncodingException {
        for (int i = 0; i < args.length; ++i) {
            long value = VariableLengthInteger.parseLong(ByteBuffer.wrap(ByteUtils.hexToBytes(args[i])));
            System.out.println(args[i] + " => " + value);
        }
    }
}

