/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import net.luminis.tls.util.ByteUtils;

public class TransportParameters {
    private byte[] originalDestinationConnectionId;
    private long maxIdleTimeout;
    private long initialMaxData;
    private long initialMaxStreamDataBidiLocal;
    private long initialMaxStreamDataBidiRemote;
    private long initialMaxStreamDataUni;
    private long initialMaxStreamsBidi;
    private long initialMaxStreamsUni;
    private int ackDelayExponent;
    private boolean disableMigration;
    private PreferredAddress preferredAddress;
    private int maxAckDelay;
    private int activeConnectionIdLimit;
    private byte[] initialSourceConnectionId;
    private byte[] retrySourceConnectionId;
    private int maxUdpPayloadSize;
    private byte[] statelessResetToken;

    public TransportParameters() {
        this.setDefaults();
    }

    public TransportParameters(int maxIdleTimeoutInSeconds, int initialMaxStreamData, int initialMaxStreamsBidirectional, int initialMaxStreamsUnidirectional) {
        this.setDefaults();
        this.maxIdleTimeout = maxIdleTimeoutInSeconds * 1000;
        this.setInitialMaxStreamData(initialMaxStreamData);
        this.initialMaxData = 10 * initialMaxStreamData;
        this.initialMaxStreamsBidi = initialMaxStreamsBidirectional;
        this.initialMaxStreamsUni = initialMaxStreamsUnidirectional;
        this.ackDelayExponent = 0;
        this.maxUdpPayloadSize = 1500;
    }

    private void setDefaults() {
        this.maxUdpPayloadSize = 65527;
        this.ackDelayExponent = 3;
        this.maxAckDelay = 25;
        this.activeConnectionIdLimit = 2;
    }

    public byte[] getOriginalDestinationConnectionId() {
        return this.originalDestinationConnectionId;
    }

    public void setOriginalDestinationConnectionId(byte[] initialSourceConnectionId) {
        this.originalDestinationConnectionId = initialSourceConnectionId;
    }

    public void setAckDelayExponent(int ackDelayExponent) {
        this.ackDelayExponent = ackDelayExponent;
    }

    public int getAckDelayExponent() {
        return this.ackDelayExponent;
    }

    public PreferredAddress getPreferredAddress() {
        return this.preferredAddress;
    }

    public void setPreferredAddress(PreferredAddress preferredAddress) {
        this.preferredAddress = preferredAddress;
    }

    public long getMaxIdleTimeout() {
        return this.maxIdleTimeout;
    }

    public void setMaxIdleTimeout(long idleTimeout) {
        this.maxIdleTimeout = idleTimeout;
    }

    public long getInitialMaxData() {
        return this.initialMaxData;
    }

    public void setInitialMaxData(long initialMaxData) {
        this.initialMaxData = initialMaxData;
    }

    public long getInitialMaxStreamDataBidiLocal() {
        return this.initialMaxStreamDataBidiLocal;
    }

    public void setInitialMaxStreamDataBidiLocal(long initialMaxStreamDataBidiLocal) {
        this.initialMaxStreamDataBidiLocal = initialMaxStreamDataBidiLocal;
    }

    public long getInitialMaxStreamDataBidiRemote() {
        return this.initialMaxStreamDataBidiRemote;
    }

    public void setInitialMaxStreamDataBidiRemote(long initialMaxStreamDataBidiRemote) {
        this.initialMaxStreamDataBidiRemote = initialMaxStreamDataBidiRemote;
    }

    public long getInitialMaxStreamDataUni() {
        return this.initialMaxStreamDataUni;
    }

    public void setInitialMaxStreamDataUni(long initialMaxStreamDataUni) {
        this.initialMaxStreamDataUni = initialMaxStreamDataUni;
    }

    public void setInitialMaxStreamData(long maxStreamData) {
        this.initialMaxStreamDataBidiLocal = maxStreamData;
        this.initialMaxStreamDataBidiRemote = maxStreamData;
        this.initialMaxStreamDataUni = maxStreamData;
    }

    public long getInitialMaxStreamsBidi() {
        return this.initialMaxStreamsBidi;
    }

    public void setInitialMaxStreamsBidi(long initialMaxStreamsBidi) {
        this.initialMaxStreamsBidi = initialMaxStreamsBidi;
    }

    public long getInitialMaxStreamsUni() {
        return this.initialMaxStreamsUni;
    }

    public void setInitialMaxStreamsUni(long initialMaxStreamsUni) {
        this.initialMaxStreamsUni = initialMaxStreamsUni;
    }

    public void setMaxAckDelay(int maxAckDelay) {
        this.maxAckDelay = maxAckDelay;
    }

    public int getMaxAckDelay() {
        return this.maxAckDelay;
    }

    public int getActiveConnectionIdLimit() {
        return this.activeConnectionIdLimit;
    }

    public void setActiveConnectionIdLimit(int activeConnectionIdLimit) {
        this.activeConnectionIdLimit = activeConnectionIdLimit;
    }

    public void setDisableMigration(boolean disableMigration) {
        this.disableMigration = disableMigration;
    }

    public boolean getDisableMigration() {
        return this.disableMigration;
    }

    public byte[] getInitialSourceConnectionId() {
        return this.initialSourceConnectionId;
    }

    public void setInitialSourceConnectionId(byte[] initialSourceConnectionId) {
        this.initialSourceConnectionId = initialSourceConnectionId;
    }

    public byte[] getRetrySourceConnectionId() {
        return this.retrySourceConnectionId;
    }

    public void setRetrySourceConnectionId(byte[] retrySourceConnectionId) {
        this.retrySourceConnectionId = retrySourceConnectionId;
    }

    public int getMaxUdpPayloadSize() {
        return this.maxUdpPayloadSize;
    }

    public void setMaxUdpPayloadSize(int maxUdpPayloadSize) {
        this.maxUdpPayloadSize = maxUdpPayloadSize;
    }

    public byte[] getStatelessResetToken() {
        return this.statelessResetToken;
    }

    public void setStatelessResetToken(byte[] statelessResetToken) {
        this.statelessResetToken = statelessResetToken;
    }

    public String toString() {
        return "\n- original destination connection id\t" + this.formatCid(this.originalDestinationConnectionId) + "\n- max idle timeout\t" + this.maxIdleTimeout / 1000L + "\n- max udp payload size\t" + this.maxUdpPayloadSize + "\n- initial max data\t\t\t" + this.initialMaxData + "\n- initial max stream data bidi local\t" + this.initialMaxStreamDataBidiLocal + "\n- initial max stream data bidi remote\t" + this.initialMaxStreamDataBidiRemote + "\n- initial max stream data unit\t\t" + this.initialMaxStreamDataUni + "\n- initial max streams bidi\t\t" + this.initialMaxStreamsBidi + "\n- initial max streams uni\t\t" + this.initialMaxStreamsUni + "\n- ack delay exponent\t\t\t" + this.ackDelayExponent + "\n- max ack delay\t\t\t\t" + this.maxAckDelay + "\n- disable migration\t\t\t" + this.disableMigration + "\n- active connection id limit\t\t" + this.activeConnectionIdLimit + "\n- initial source connection id\t\t" + this.formatCid(this.initialSourceConnectionId) + "\n- retry source connection id\t\t" + this.formatCid(this.retrySourceConnectionId);
    }

    private String formatCid(byte[] data) {
        if (data != null) {
            return ByteUtils.bytesToHex(data);
        }
        return "null";
    }

    public static class PreferredAddress {
        InetAddress ip4;
        int ip4Port;
        InetAddress ip6;
        int ip6Port;
        byte[] connectionId;
        byte[] statelessResetToken;

        public InetAddress getIp4() {
            return this.ip4;
        }

        public void setIp4(InetAddress ip4) {
            this.ip4 = ip4;
        }

        public int getIp4Port() {
            return this.ip4Port;
        }

        public void setIp4Port(int ip4Port) {
            this.ip4Port = ip4Port;
        }

        public InetAddress getIp6() {
            return this.ip6;
        }

        public void setIp6(InetAddress ip6) {
            this.ip6 = ip6;
        }

        public int getIp6Port() {
            return this.ip6Port;
        }

        public void setIp6Port(int ip6Port) {
            this.ip6Port = ip6Port;
        }

        public byte[] getConnectionId() {
            return this.connectionId;
        }

        public byte[] getStatelessResetToken() {
            return this.statelessResetToken;
        }

        public void setConnectionId(ByteBuffer buffer, int connectionIdSize) {
            this.connectionId = new byte[connectionIdSize];
            buffer.get(this.connectionId);
        }

        public void setStatelessResetToken(ByteBuffer buffer, int size) {
            this.statelessResetToken = new byte[size];
            buffer.get(this.statelessResetToken);
        }
    }
}

