/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Instant;

public class RawPacket {
    private final DatagramPacket receivedPacket;
    private final Instant timeReceived;
    private final int number;
    private final ByteBuffer data;

    public RawPacket(DatagramPacket receivedPacket, Instant timeReceived, int number) {
        this.receivedPacket = receivedPacket;
        this.timeReceived = timeReceived;
        this.number = number;
        this.data = ByteBuffer.wrap(receivedPacket.getData(), 0, receivedPacket.getLength());
    }

    public Instant getTimeReceived() {
        return this.timeReceived;
    }

    public int getNumber() {
        return this.number;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public int getLength() {
        return this.data.limit();
    }

    public InetAddress getAddress() {
        return this.receivedPacket.getAddress();
    }

    public int getPort() {
        return this.receivedPacket.getPort();
    }
}

