/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic;

import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import net.luminis.quic.CryptoStream;
import net.luminis.quic.DecryptionException;
import net.luminis.quic.EncryptionLevel;
import net.luminis.quic.FrameProcessorRegistry;
import net.luminis.quic.GlobalAckGenerator;
import net.luminis.quic.HandshakeState;
import net.luminis.quic.HandshakeStateListener;
import net.luminis.quic.IdleTimer;
import net.luminis.quic.InvalidPacketException;
import net.luminis.quic.MissingKeysException;
import net.luminis.quic.PacketProcessor;
import net.luminis.quic.QuicConnection;
import net.luminis.quic.QuicConstants;
import net.luminis.quic.QuicStream;
import net.luminis.quic.Role;
import net.luminis.quic.Statistics;
import net.luminis.quic.TransportError;
import net.luminis.quic.TransportParameters;
import net.luminis.quic.Version;
import net.luminis.quic.concurrent.DaemonThreadFactory;
import net.luminis.quic.crypto.ConnectionSecrets;
import net.luminis.quic.crypto.Keys;
import net.luminis.quic.frame.AckFrame;
import net.luminis.quic.frame.ConnectionCloseFrame;
import net.luminis.quic.frame.CryptoFrame;
import net.luminis.quic.frame.DataBlockedFrame;
import net.luminis.quic.frame.FrameProcessor3;
import net.luminis.quic.frame.MaxDataFrame;
import net.luminis.quic.frame.MaxStreamDataFrame;
import net.luminis.quic.frame.MaxStreamsFrame;
import net.luminis.quic.frame.Padding;
import net.luminis.quic.frame.PathResponseFrame;
import net.luminis.quic.frame.PingFrame;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.frame.ResetStreamFrame;
import net.luminis.quic.frame.StopSendingFrame;
import net.luminis.quic.frame.StreamDataBlockedFrame;
import net.luminis.quic.frame.StreamFrame;
import net.luminis.quic.frame.StreamsBlockedFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.HandshakePacket;
import net.luminis.quic.packet.InitialPacket;
import net.luminis.quic.packet.QuicPacket;
import net.luminis.quic.packet.RetryPacket;
import net.luminis.quic.packet.ShortHeaderPacket;
import net.luminis.quic.packet.VersionNegotiationPacket;
import net.luminis.quic.recovery.RecoveryManager;
import net.luminis.quic.send.Sender;
import net.luminis.quic.send.SenderImpl;
import net.luminis.quic.stream.FlowControl;
import net.luminis.quic.stream.StreamManager;
import net.luminis.quic.util.ProgressivelyIncreasingRateLimiter;
import net.luminis.quic.util.RateLimiter;
import net.luminis.tls.TlsProtocolException;
import net.luminis.tls.alert.ErrorAlert;
import net.luminis.tls.handshake.TlsEngine;
import net.luminis.tls.util.ByteUtils;

public abstract class QuicConnectionImpl
implements QuicConnection,
FrameProcessorRegistry<AckFrame>,
PacketProcessor,
FrameProcessor3 {
    protected final Version quicVersion;
    private final Role role;
    protected final Logger log;
    protected final ConnectionSecrets connectionSecrets;
    protected volatile TransportParameters transportParams;
    protected volatile HandshakeState handshakeState = HandshakeState.Initial;
    protected List<HandshakeStateListener> handshakeStateListeners = new CopyOnWriteArrayList<HandshakeStateListener>();
    protected IdleTimer idleTimer;
    protected final List<Runnable> postProcessingActions = new ArrayList<Runnable>();
    protected final List<CryptoStream> cryptoStreams = new ArrayList<CryptoStream>();
    protected volatile FlowControl flowController;
    protected long flowControlMax;
    protected long flowControlLastAdvertised;
    protected long flowControlIncrement;
    protected long largestPacketNumber;
    protected volatile Status connectionState;
    private RateLimiter closeFramesSendRateLimiter;
    private final ScheduledExecutorService scheduler;

    protected QuicConnectionImpl(Version quicVersion, Role role, Path secretsFile, Logger log) {
        this.quicVersion = quicVersion;
        this.role = role;
        this.log = log;
        this.connectionSecrets = new ConnectionSecrets(quicVersion, role, secretsFile, log);
        this.transportParams = new TransportParameters(60, 250000, 3, 3);
        this.flowControlLastAdvertised = this.flowControlMax = this.transportParams.getInitialMaxData();
        this.flowControlIncrement = this.flowControlMax / 10L;
        this.connectionState = Status.Created;
        this.closeFramesSendRateLimiter = new ProgressivelyIncreasingRateLimiter();
        this.scheduler = Executors.newScheduledThreadPool(1, new DaemonThreadFactory("scheduler"));
    }

    public void addHandshakeStateListener(RecoveryManager recoveryManager) {
        this.handshakeStateListeners.add(recoveryManager);
    }

    public void updateConnectionFlowControl(int size) {
        this.flowControlMax += (long)size;
        if (this.flowControlMax - this.flowControlLastAdvertised > this.flowControlIncrement) {
            this.send(new MaxDataFrame(this.flowControlMax), f -> {});
            this.flowControlLastAdvertised = this.flowControlMax;
        }
    }

    public void send(QuicFrame frame, Consumer<QuicFrame> lostFrameCallback) {
        this.send(frame, lostFrameCallback, false);
    }

    public void send(QuicFrame frame, Consumer<QuicFrame> lostFrameCallback, boolean flush) {
        this.getSender().send(frame, EncryptionLevel.App, lostFrameCallback);
        if (flush) {
            this.getSender().flush();
        }
    }

    public void send(QuicFrame frame, EncryptionLevel level, Consumer<QuicFrame> lostFrameCallback, boolean flush) {
        this.getSender().send(frame, level, lostFrameCallback);
        if (flush) {
            this.getSender().flush();
        }
    }

    public void send(Function<Integer, QuicFrame> frameSupplier, int minimumSize, EncryptionLevel level, Consumer<QuicFrame> lostCallback) {
        this.getSender().send(frameSupplier, minimumSize, level, lostCallback);
    }

    public void send(Function<Integer, QuicFrame> frameSupplier, int minimumSize, EncryptionLevel level, Consumer<QuicFrame> lostCallback, boolean flush) {
        this.getSender().send(frameSupplier, minimumSize, level, lostCallback);
        if (flush) {
            this.getSender().flush();
        }
    }

    @Override
    public QuicStream createStream(boolean bidirectional) {
        return this.getStreamManager().createStream(bidirectional);
    }

    public void parseAndProcessPackets(int datagram, Instant timeReceived, ByteBuffer data, QuicPacket parsedPacket) {
        while (data.remaining() > 0 || parsedPacket != null) {
            try {
                QuicPacket packet;
                if (parsedPacket == null) {
                    packet = this.parsePacket(data);
                    this.log.received(timeReceived, datagram, packet);
                    this.log.debug("Parsed packet with size " + data.position() + "; " + data.remaining() + " bytes left.");
                } else {
                    packet = parsedPacket;
                    parsedPacket = null;
                }
                this.processPacket(timeReceived, packet);
                this.getSender().packetProcessed(data.hasRemaining());
            }
            catch (DecryptionException | MissingKeysException cannotParse) {
                int nrOfPacketBytes = data.position();
                if (nrOfPacketBytes == 0) {
                    nrOfPacketBytes = data.remaining();
                }
                this.log.error("Discarding packet (" + nrOfPacketBytes + " bytes) that cannot be decrypted (" + cannotParse + ")");
            }
            catch (InvalidPacketException invalidPacket) {
                this.log.debug("Dropping invalid packet");
                return;
            }
            if (data.position() == 0) break;
            data = data.slice();
        }
        this.getSender().packetProcessed(false);
        this.postProcessingActions.forEach(action -> action.run());
        this.postProcessingActions.clear();
    }

    protected QuicPacket parsePacket(ByteBuffer data) throws MissingKeysException, DecryptionException, InvalidPacketException {
        data.mark();
        if (data.remaining() < 2) {
            throw new InvalidPacketException("packet too short to be valid QUIC packet");
        }
        byte flags = data.get();
        if ((flags & 0x40) != 64) {
            throw new InvalidPacketException();
        }
        QuicPacket packet = (flags & 0x80) == 128 ? this.createLongHeaderPacket(flags, data) : new ShortHeaderPacket(this.quicVersion);
        data.rewind();
        if (packet.getEncryptionLevel() != null) {
            Keys keys = this.connectionSecrets.getPeerSecrets(packet.getEncryptionLevel());
            if (keys == null) {
                throw new MissingKeysException(packet.getEncryptionLevel());
            }
            packet.parse(data, keys, this.largestPacketNumber, this.log, this.getSourceConnectionIdLength());
        } else {
            packet.parse(data, null, this.largestPacketNumber, this.log, 0);
        }
        if (packet.getPacketNumber() != null && packet.getPacketNumber() > this.largestPacketNumber) {
            this.largestPacketNumber = packet.getPacketNumber();
        }
        return packet;
    }

    protected void processFrames(QuicPacket packet, Instant timeReceived) {
        for (QuicFrame frame : packet.getFrames()) {
            frame.accept(this, packet, timeReceived);
        }
    }

    protected abstract int getSourceConnectionIdLength();

    private QuicPacket createLongHeaderPacket(int flags, ByteBuffer data) throws InvalidPacketException {
        int MIN_LONGHEADERPACKET_LENGTH = 7;
        if (1 + data.remaining() < 7) {
            throw new InvalidPacketException("packet too short to be valid QUIC long header packet");
        }
        int version = data.getInt();
        if (version == 0) {
            return new VersionNegotiationPacket(this.quicVersion);
        }
        if ((flags & 0xF0) == 192) {
            return new InitialPacket(this.quicVersion);
        }
        if ((flags & 0xF0) == 240) {
            return new RetryPacket(this.quicVersion);
        }
        if ((flags & 0xF0) == 224) {
            return new HandshakePacket(this.quicVersion);
        }
        if ((flags & 0xF0) == 208) {
            throw new InvalidPacketException();
        }
        throw new RuntimeException();
    }

    protected void processPacket(Instant timeReceived, QuicPacket packet) {
        this.log.getQLog().emitPacketReceivedEvent(packet, timeReceived);
        if (!this.connectionState.closingOrDraining()) {
            PacketProcessor.ProcessResult result = packet.accept(this, timeReceived);
            if (result == PacketProcessor.ProcessResult.Abort) {
                return;
            }
            this.getAckGenerator().packetReceived(packet);
            this.idleTimer.packetProcessed();
        } else if (this.connectionState.isClosing()) {
            this.handlePacketInClosingState(packet);
        }
    }

    @Override
    public void process(CryptoFrame cryptoFrame, QuicPacket packet, Instant timeReceived) {
        try {
            this.getCryptoStream(packet.getEncryptionLevel()).add(cryptoFrame);
            this.log.receivedPacketInfo(this.getCryptoStream(packet.getEncryptionLevel()).toStringReceived());
        }
        catch (TlsProtocolException e) {
            this.immediateCloseWithError(packet.getEncryptionLevel(), this.quicError(e), e.getMessage());
        }
    }

    @Override
    public void process(ConnectionCloseFrame connectionCloseFrame, QuicPacket packet, Instant timeReceived) {
        this.handlePeerClosing(connectionCloseFrame, packet.getEncryptionLevel());
    }

    @Override
    public void process(DataBlockedFrame dataBlockedFrame, QuicPacket packet, Instant timeReceived) {
    }

    @Override
    public void process(MaxDataFrame maxDataFrame, QuicPacket packet, Instant timeReceived) {
        this.flowController.process(maxDataFrame);
    }

    @Override
    public void process(MaxStreamDataFrame maxStreamDataFrame, QuicPacket packet, Instant timeReceived) {
        try {
            this.flowController.process(maxStreamDataFrame);
        }
        catch (TransportError transportError) {
            this.immediateCloseWithError(EncryptionLevel.App, transportError.getTransportErrorCode().value, null);
        }
    }

    @Override
    public void process(MaxStreamsFrame maxStreamsFrame, QuicPacket packet, Instant timeReceived) {
        this.getStreamManager().process(maxStreamsFrame);
    }

    @Override
    public void process(Padding paddingFrame, QuicPacket packet, Instant timeReceived) {
    }

    @Override
    public void process(PathResponseFrame pathResponseFrame, QuicPacket packet, Instant timeReceived) {
    }

    @Override
    public void process(PingFrame pingFrame, QuicPacket packet, Instant timeReceived) {
    }

    @Override
    public void process(ResetStreamFrame resetStreamFrame, QuicPacket packet, Instant timeReceived) {
        this.getStreamManager().process(resetStreamFrame);
    }

    @Override
    public void process(StopSendingFrame stopSendingFrame, QuicPacket packet, Instant timeReceived) {
        this.getStreamManager().process(stopSendingFrame);
    }

    @Override
    public void process(StreamFrame streamFrame, QuicPacket packet, Instant timeReceived) {
        try {
            this.getStreamManager().process(streamFrame);
        }
        catch (TransportError transportError) {
            this.immediateCloseWithError(EncryptionLevel.App, transportError.getTransportErrorCode().value, null);
        }
    }

    @Override
    public void process(StreamDataBlockedFrame streamDataBlockedFrame, QuicPacket packet, Instant timeReceived) {
    }

    @Override
    public void process(StreamsBlockedFrame streamsBlockedFrame, QuicPacket packet, Instant timeReceived) {
    }

    protected CryptoStream getCryptoStream(EncryptionLevel encryptionLevel) {
        if (this.cryptoStreams.size() <= encryptionLevel.ordinal()) {
            for (int i = encryptionLevel.ordinal() - this.cryptoStreams.size(); i >= 0; --i) {
                this.cryptoStreams.add(new CryptoStream(this.quicVersion, encryptionLevel, this.connectionSecrets, this.role, this.getTlsEngine(), this.log, this.getSender()));
            }
        }
        return this.cryptoStreams.get(encryptionLevel.ordinal());
    }

    protected void determineIdleTimeout(long maxIdleTimout, long peerMaxIdleTimeout) {
        long idleTimeout = Long.min(maxIdleTimout, peerMaxIdleTimeout);
        if (idleTimeout == 0L) {
            idleTimeout = Long.max(maxIdleTimout, peerMaxIdleTimeout);
        }
        if (idleTimeout != 0L) {
            this.log.debug("Effective idle timeout is " + idleTimeout);
            this.idleTimer.setIdleTimeout(idleTimeout);
        }
    }

    protected void silentlyCloseConnection(long idleTime) {
        this.getStreamManager().abortAll();
        this.getSender().stop();
        this.log.info("Idle timeout: silently closing connection after " + idleTime + " ms of inactivity (" + ByteUtils.bytesToHex(this.getSourceConnectionId()) + ")");
        this.log.getQLog().emitConnectionClosedEvent(Instant.now());
        this.terminate();
    }

    protected void immediateClose(EncryptionLevel level) {
        this.immediateCloseWithError(level, QuicConstants.TransportErrorCode.NO_ERROR.value, null);
        this.log.getQLog().emitConnectionClosedEvent(Instant.now(), QuicConstants.TransportErrorCode.NO_ERROR.value, null);
    }

    protected void immediateCloseWithError(EncryptionLevel level, int error, String errorReason) {
        if (this.connectionState == Status.Closing || this.connectionState == Status.Draining) {
            this.log.debug("Immediate close ignored because already closing");
            return;
        }
        this.getSender().stop();
        this.getSender().send(new ConnectionCloseFrame(this.quicVersion, error, errorReason), level);
        this.connectionState = Status.Closing;
        this.getStreamManager().abortAll();
        if (level != EncryptionLevel.Initial) {
            int pto = this.getSender().getPto();
            this.schedule(() -> this.terminate(), 3 * pto, TimeUnit.MILLISECONDS);
        } else {
            this.postProcessingActions.add(() -> this.terminate());
        }
        this.log.getQLog().emitConnectionClosedEvent(Instant.now(), error, errorReason);
    }

    protected void handlePacketInClosingState(QuicPacket packet) {
        if (packet.getFrames().stream().filter(frame -> frame instanceof ConnectionCloseFrame).findAny().isPresent()) {
            this.connectionState = Status.Draining;
        } else {
            this.closeFramesSendRateLimiter.execute(() -> this.send(new ConnectionCloseFrame(this.quicVersion), packet.getEncryptionLevel(), Sender.NO_RETRANSMIT, false));
        }
    }

    protected void handlePeerClosing(ConnectionCloseFrame closing, EncryptionLevel encryptionLevel) {
        if (!this.connectionState.closingOrDraining()) {
            if (closing.hasError()) {
                this.log.error("Connection closed by peer with " + this.determineClosingErrorMessage(closing));
            } else {
                this.log.info("Peer is closing");
            }
            this.getSender().stop();
            this.send(new ConnectionCloseFrame(this.quicVersion), encryptionLevel, Sender.NO_RETRANSMIT, false);
            this.connectionState = Status.Draining;
            int pto = this.getSender().getPto();
            this.schedule(() -> this.terminate(), 3 * pto, TimeUnit.MILLISECONDS);
        }
    }

    protected String determineClosingErrorMessage(ConnectionCloseFrame closing) {
        if (closing.hasTransportError()) {
            if (closing.hasTlsError()) {
                return "TLS error " + closing.getTlsError() + (String)(closing.hasReasonPhrase() ? ": " + closing.getReasonPhrase() : "");
            }
            return "transport error " + closing.getErrorCode() + (String)(closing.hasReasonPhrase() ? ": " + closing.getReasonPhrase() : "");
        }
        if (closing.hasApplicationProtocolError()) {
            return "application protocol error " + closing.getErrorCode() + (String)(closing.hasReasonPhrase() ? ": " + closing.getReasonPhrase() : "");
        }
        return "";
    }

    protected void terminate() {
        this.idleTimer.shutdown();
        this.getSender().shutdown();
        this.connectionState = Status.Closed;
        this.scheduler.shutdown();
    }

    protected int quicError(TlsProtocolException tlsError) {
        if (tlsError instanceof ErrorAlert) {
            return 256 + ((ErrorAlert)tlsError).alertDescription().value;
        }
        if (tlsError.getCause() instanceof TransportError) {
            return ((TransportError)tlsError.getCause()).getTransportErrorCode().value;
        }
        return QuicConstants.TransportErrorCode.INTERNAL_ERROR.value;
    }

    public abstract void abortConnection(Throwable var1);

    public static int getMaxPacketSize() {
        return 1232;
    }

    @Override
    public void close() {
        this.immediateClose(EncryptionLevel.App);
        this.getSender().flush();
    }

    @Override
    public void close(QuicConstants.TransportErrorCode applicationError, String errorReason) {
        this.immediateCloseWithError(EncryptionLevel.App, applicationError.value, errorReason);
    }

    private void schedule(Runnable command, int delay, TimeUnit unit) {
        try {
            this.scheduler.schedule(command, (long)delay, unit);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public Statistics getStats() {
        return new Statistics(this.getSender().getStatistics());
    }

    @Override
    public Version getQuicVersion() {
        return this.quicVersion;
    }

    protected abstract SenderImpl getSender();

    protected abstract TlsEngine getTlsEngine();

    protected abstract GlobalAckGenerator getAckGenerator();

    protected abstract StreamManager getStreamManager();

    public abstract long getInitialMaxStreamData();

    public abstract int getMaxShortHeaderPacketOverhead();

    public abstract byte[] getSourceConnectionId();

    public abstract byte[] getDestinationConnectionId();

    public IdleTimer getIdleTimer() {
        return this.idleTimer;
    }

    public Role getRole() {
        return this.role;
    }

    public static enum Status {
        Created,
        Handshaking,
        Connected,
        Closing,
        Draining,
        Closed,
        Failed;


        public boolean closingOrDraining() {
            return this == Closing || this == Draining;
        }

        public boolean isClosing() {
            return this == Closing;
        }
    }
}

