/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic;

import java.io.IOException;
import java.net.ConnectException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.net.ssl.X509TrustManager;
import net.luminis.quic.CryptoStream;
import net.luminis.quic.EarlyDataStatus;
import net.luminis.quic.EncryptionLevel;
import net.luminis.quic.FrameProcessor2;
import net.luminis.quic.FrameProcessorRegistry;
import net.luminis.quic.GlobalAckGenerator;
import net.luminis.quic.HandshakeState;
import net.luminis.quic.IdleTimer;
import net.luminis.quic.KeepAliveActor;
import net.luminis.quic.PacketProcessor;
import net.luminis.quic.PnSpace;
import net.luminis.quic.QuicClientConnection;
import net.luminis.quic.QuicConnectionImpl;
import net.luminis.quic.QuicConstants;
import net.luminis.quic.QuicSessionTicket;
import net.luminis.quic.QuicStream;
import net.luminis.quic.RawPacket;
import net.luminis.quic.Receiver;
import net.luminis.quic.Role;
import net.luminis.quic.TransportParameters;
import net.luminis.quic.Version;
import net.luminis.quic.VersionNegotiationFailure;
import net.luminis.quic.cid.ConnectionIdInfo;
import net.luminis.quic.cid.DestinationConnectionIdRegistry;
import net.luminis.quic.cid.SourceConnectionIdRegistry;
import net.luminis.quic.frame.AckFrame;
import net.luminis.quic.frame.FrameProcessor3;
import net.luminis.quic.frame.HandshakeDoneFrame;
import net.luminis.quic.frame.NewConnectionIdFrame;
import net.luminis.quic.frame.NewTokenFrame;
import net.luminis.quic.frame.PathChallengeFrame;
import net.luminis.quic.frame.PathResponseFrame;
import net.luminis.quic.frame.PingFrame;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.frame.RetireConnectionIdFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.log.NullLogger;
import net.luminis.quic.packet.HandshakePacket;
import net.luminis.quic.packet.InitialPacket;
import net.luminis.quic.packet.QuicPacket;
import net.luminis.quic.packet.RetryPacket;
import net.luminis.quic.packet.ShortHeaderPacket;
import net.luminis.quic.packet.VersionNegotiationPacket;
import net.luminis.quic.packet.ZeroRttPacket;
import net.luminis.quic.send.SenderImpl;
import net.luminis.quic.stream.EarlyDataStream;
import net.luminis.quic.stream.FlowControl;
import net.luminis.quic.stream.StreamManager;
import net.luminis.quic.tls.QuicTransportParametersExtension;
import net.luminis.tls.CertificateWithPrivateKey;
import net.luminis.tls.NewSessionTicket;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.extension.ApplicationLayerProtocolNegotiationExtension;
import net.luminis.tls.extension.EarlyDataExtension;
import net.luminis.tls.extension.Extension;
import net.luminis.tls.handshake.CertificateMessage;
import net.luminis.tls.handshake.CertificateVerifyMessage;
import net.luminis.tls.handshake.ClientHello;
import net.luminis.tls.handshake.ClientMessageSender;
import net.luminis.tls.handshake.FinishedMessage;
import net.luminis.tls.handshake.TlsClientEngine;
import net.luminis.tls.handshake.TlsStatusEventHandler;
import net.luminis.tls.util.ByteUtils;

public class QuicClientConnectionImpl
extends QuicConnectionImpl
implements QuicClientConnection,
PacketProcessor,
FrameProcessorRegistry<AckFrame>,
TlsStatusEventHandler,
FrameProcessor3 {
    private final String host;
    private final int port;
    private final QuicSessionTicket sessionTicket;
    private final TlsClientEngine tlsEngine;
    private final DatagramSocket socket;
    private final InetAddress serverAddress;
    private final SenderImpl sender;
    private final Receiver receiver;
    private final StreamManager streamManager;
    private final X509Certificate clientCertificate;
    private final PrivateKey clientCertificateKey;
    private volatile byte[] token;
    private final CountDownLatch handshakeFinishedCondition = new CountDownLatch(1);
    private volatile TransportParameters peerTransportParams;
    private DestinationConnectionIdRegistry destConnectionIds;
    private SourceConnectionIdRegistry sourceConnectionIds;
    private KeepAliveActor keepAliveActor;
    private String applicationProtocol;
    private final List<QuicSessionTicket> newSessionTickets = Collections.synchronizedList(new ArrayList());
    private boolean ignoreVersionNegotiation;
    private volatile EarlyDataStatus earlyDataStatus = EarlyDataStatus.None;
    private List<FrameProcessor2<AckFrame>> ackProcessors = new CopyOnWriteArrayList<FrameProcessor2<AckFrame>>();
    private final List<TlsConstants.CipherSuite> cipherSuites;
    private final GlobalAckGenerator ackGenerator;
    private Integer clientHelloEnlargement;
    private volatile Thread receiverThread;
    private volatile boolean processedRetryPacket = false;

    private QuicClientConnectionImpl(String host, int port, QuicSessionTicket sessionTicket, Version quicVersion, final Logger log, String proxyHost, Path secretsFile, Integer initialRtt, Integer cidLength, List<TlsConstants.CipherSuite> cipherSuites, X509Certificate clientCertificate, PrivateKey clientCertificateKey) throws UnknownHostException, SocketException {
        super(quicVersion, Role.Client, secretsFile, log);
        log.info("Creating connection with " + host + ":" + port + " with " + quicVersion);
        this.host = host;
        this.port = port;
        this.serverAddress = InetAddress.getByName(proxyHost != null ? proxyHost : host);
        this.sessionTicket = sessionTicket;
        this.cipherSuites = cipherSuites;
        this.clientCertificate = clientCertificate;
        this.clientCertificateKey = clientCertificateKey;
        this.socket = new DatagramSocket();
        this.idleTimer = new IdleTimer(this, log);
        this.sender = new SenderImpl(quicVersion, QuicClientConnectionImpl.getMaxPacketSize(), this.socket, new InetSocketAddress(this.serverAddress, port), this, initialRtt, log);
        this.idleTimer.setPtoSupplier(this.sender::getPto);
        this.ackGenerator = this.sender.getGlobalAckGenerator();
        this.registerProcessor(this.ackGenerator);
        this.receiver = new Receiver(this.socket, log, this::abortConnection);
        this.streamManager = new StreamManager(this, Role.Client, log, 10, 10);
        this.sourceConnectionIds = new SourceConnectionIdRegistry(cidLength, log);
        this.destConnectionIds = new DestinationConnectionIdRegistry(log);
        this.connectionState = QuicConnectionImpl.Status.Created;
        this.tlsEngine = new TlsClientEngine(new ClientMessageSender(){

            @Override
            public void send(ClientHello clientHello) {
                CryptoStream cryptoStream = QuicClientConnectionImpl.this.getCryptoStream(EncryptionLevel.Initial);
                cryptoStream.write(clientHello, true);
                QuicClientConnectionImpl.this.connectionState = QuicConnectionImpl.Status.Handshaking;
                QuicClientConnectionImpl.this.connectionSecrets.setClientRandom(clientHello.getClientRandom());
                log.sentPacketInfo(cryptoStream.toStringSent());
            }

            @Override
            public void send(FinishedMessage finished) {
                CryptoStream cryptoStream = QuicClientConnectionImpl.this.getCryptoStream(EncryptionLevel.Handshake);
                cryptoStream.write(finished, true);
                log.sentPacketInfo(cryptoStream.toStringSent());
            }

            @Override
            public void send(CertificateMessage certificateMessage) throws IOException {
                CryptoStream cryptoStream = QuicClientConnectionImpl.this.getCryptoStream(EncryptionLevel.Handshake);
                cryptoStream.write(certificateMessage, true);
                log.sentPacketInfo(cryptoStream.toStringSent());
            }

            @Override
            public void send(CertificateVerifyMessage certificateVerifyMessage) {
                CryptoStream cryptoStream = QuicClientConnectionImpl.this.getCryptoStream(EncryptionLevel.Handshake);
                cryptoStream.write(certificateVerifyMessage, true);
                log.sentPacketInfo(cryptoStream.toStringSent());
            }
        }, this);
    }

    @Override
    public void connect(int connectionTimeout, String alpn) throws IOException {
        this.connect(connectionTimeout, alpn, null, null);
    }

    @Override
    public void connect(int connectionTimeout, String alpn, TransportParameters transportParameters) throws IOException {
        this.connect(connectionTimeout, alpn, transportParameters, null);
    }

    @Override
    public synchronized List<QuicStream> connect(int connectionTimeout, String applicationProtocol, TransportParameters transportParameters, List<QuicClientConnection.StreamEarlyData> earlyData) throws IOException {
        if (this.connectionState != QuicConnectionImpl.Status.Created) {
            throw new IllegalStateException("Cannot connect a connection that is in state " + this.connectionState);
        }
        this.applicationProtocol = applicationProtocol;
        if (transportParameters != null) {
            this.transportParams = transportParameters;
        }
        this.transportParams.setInitialSourceConnectionId(this.sourceConnectionIds.getCurrent());
        if (earlyData == null) {
            earlyData = Collections.emptyList();
        }
        this.log.info(String.format("Original destination connection id: %s (scid: %s)", ByteUtils.bytesToHex(this.destConnectionIds.getCurrent()), ByteUtils.bytesToHex(this.sourceConnectionIds.getCurrent())));
        this.generateInitialKeys();
        this.receiver.start();
        this.sender.start(this.connectionSecrets);
        this.startReceiverLoop();
        this.startHandshake(applicationProtocol, !earlyData.isEmpty());
        List<QuicStream> earlyDataStreams = this.sendEarlyData(earlyData);
        try {
            boolean handshakeFinished = this.handshakeFinishedCondition.await(connectionTimeout, TimeUnit.MILLISECONDS);
            if (!handshakeFinished) {
                this.abortHandshake();
                throw new ConnectException("Connection timed out after " + connectionTimeout + " ms");
            }
            if (this.connectionState != QuicConnectionImpl.Status.Connected) {
                this.abortHandshake();
                throw new ConnectException("Handshake error");
            }
        }
        catch (InterruptedException e) {
            this.abortHandshake();
            throw new RuntimeException();
        }
        if (!earlyData.isEmpty()) {
            if (this.earlyDataStatus != EarlyDataStatus.Accepted) {
                this.log.info("Server did not accept early data; retransmitting all data.");
            }
            for (QuicStream stream : earlyDataStreams) {
                if (stream == null) continue;
                ((EarlyDataStream)stream).writeRemaining(this.earlyDataStatus == EarlyDataStatus.Accepted);
            }
        }
        return earlyDataStreams;
    }

    private List<QuicStream> sendEarlyData(List<QuicClientConnection.StreamEarlyData> streamEarlyDataList) throws IOException {
        if (!streamEarlyDataList.isEmpty()) {
            TransportParameters rememberedTransportParameters = new TransportParameters();
            this.sessionTicket.copyTo(rememberedTransportParameters);
            this.setPeerTransportParameters(rememberedTransportParameters, false);
            long earlyDataSizeLeft = this.sessionTicket.getInitialMaxData();
            ArrayList<QuicStream> earlyDataStreams = new ArrayList<QuicStream>();
            for (QuicClientConnection.StreamEarlyData streamEarlyData : streamEarlyDataList) {
                EarlyDataStream earlyDataStream = this.streamManager.createEarlyDataStream(true);
                if (earlyDataStream != null) {
                    earlyDataStream.writeEarlyData(streamEarlyData.data, streamEarlyData.closeOutput, earlyDataSizeLeft);
                    earlyDataSizeLeft = Long.max(0L, earlyDataSizeLeft - (long)streamEarlyData.data.length);
                } else {
                    this.log.info("Creating early data stream failed, max bidi streams = " + rememberedTransportParameters.getInitialMaxStreamsBidi());
                }
                earlyDataStreams.add(earlyDataStream);
            }
            this.earlyDataStatus = EarlyDataStatus.Requested;
            return earlyDataStreams;
        }
        return Collections.emptyList();
    }

    private void abortHandshake() {
        this.connectionState = QuicConnectionImpl.Status.Failed;
        this.sender.stop();
        this.terminate();
    }

    @Override
    public void keepAlive(int seconds) {
        if (this.connectionState != QuicConnectionImpl.Status.Connected) {
            throw new IllegalStateException("keep alive can only be set when connected");
        }
        this.keepAliveActor = new KeepAliveActor(this.quicVersion, seconds, (int)this.peerTransportParams.getMaxIdleTimeout(), this.sender);
    }

    public void ping() {
        if (this.connectionState != QuicConnectionImpl.Status.Connected) {
            throw new IllegalStateException("not connected");
        }
        this.sender.send(new PingFrame(this.quicVersion), EncryptionLevel.App);
        this.sender.flush();
    }

    private void startReceiverLoop() {
        this.receiverThread = new Thread(this::receiveAndProcessPackets, "receiver-loop");
        this.receiverThread.setDaemon(true);
        this.receiverThread.start();
    }

    private void receiveAndProcessPackets() {
        Thread currentThread = Thread.currentThread();
        int receivedPacketCounter = 0;
        try {
            while (!currentThread.isInterrupted()) {
                RawPacket rawPacket = this.receiver.get(15);
                if (rawPacket == null) continue;
                Duration processDelay = Duration.between(rawPacket.getTimeReceived(), Instant.now());
                this.log.raw("Start processing packet " + ++receivedPacketCounter + " (" + rawPacket.getLength() + " bytes)", rawPacket.getData(), 0, rawPacket.getLength());
                this.log.debug("Processing delay for packet #" + receivedPacketCounter + ": " + processDelay.toMillis() + " ms");
                this.parseAndProcessPackets(receivedPacketCounter, rawPacket.getTimeReceived(), rawPacket.getData(), null);
                this.sender.datagramProcessed(this.receiver.hasMore());
            }
        }
        catch (InterruptedException e) {
            this.log.debug("Terminating receiver loop because of interrupt");
        }
        catch (Exception error) {
            this.log.error("Terminating receiver loop because of error", error);
            this.abortConnection(error);
        }
    }

    private void generateInitialKeys() {
        this.connectionSecrets.computeInitialKeys(this.destConnectionIds.getCurrent());
    }

    private void startHandshake(String applicationProtocol, boolean withEarlyData) {
        this.tlsEngine.setServerName(this.host);
        this.tlsEngine.addSupportedCiphers(this.cipherSuites);
        if (this.clientCertificate != null && this.clientCertificateKey != null) {
            this.tlsEngine.setClientCertificateCallback(authorities -> {
                if (!authorities.contains(this.clientCertificate.getIssuerX500Principal())) {
                    this.log.warn("Client certificate is not signed by one of the requested authorities: " + authorities);
                }
                return new CertificateWithPrivateKey(this.clientCertificate, this.clientCertificateKey);
            });
        }
        QuicTransportParametersExtension tpExtension = new QuicTransportParametersExtension(this.quicVersion, this.transportParams, Role.Client);
        if (this.clientHelloEnlargement != null) {
            tpExtension.addDiscardTransportParameter(this.clientHelloEnlargement);
        }
        this.tlsEngine.add(tpExtension);
        this.tlsEngine.add(new ApplicationLayerProtocolNegotiationExtension(applicationProtocol));
        if (withEarlyData) {
            this.tlsEngine.add(new EarlyDataExtension());
        }
        if (this.sessionTicket != null) {
            this.tlsEngine.setNewSessionTicket(this.sessionTicket);
        }
        try {
            this.tlsEngine.startHandshake();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void earlySecretsKnown() {
        this.connectionSecrets.computeEarlySecrets(this.tlsEngine);
    }

    @Override
    public void handshakeSecretsKnown() {
        this.connectionSecrets.computeHandshakeSecrets(this.tlsEngine, this.tlsEngine.getSelectedCipher());
        this.hasHandshakeKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hasHandshakeKeys() {
        HandshakeState handshakeState = this.handshakeState;
        synchronized (handshakeState) {
            if (this.handshakeState.transitionAllowed(HandshakeState.HasHandshakeKeys)) {
                this.handshakeState = HandshakeState.HasHandshakeKeys;
                this.handshakeStateListeners.forEach(l -> l.handshakeStateChangedEvent(this.handshakeState));
            } else {
                this.log.debug("Handshake state cannot be set to HasHandshakeKeys");
            }
        }
        this.postProcessingActions.add(() -> this.discard(PnSpace.Initial, "first Handshake message is being sent"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handshakeFinished() {
        this.connectionSecrets.computeApplicationSecrets(this.tlsEngine);
        HandshakeState handshakeState = this.handshakeState;
        synchronized (handshakeState) {
            if (this.handshakeState.transitionAllowed(HandshakeState.HasAppKeys)) {
                this.handshakeState = HandshakeState.HasAppKeys;
                this.handshakeStateListeners.forEach(l -> l.handshakeStateChangedEvent(this.handshakeState));
            } else {
                this.log.error("Handshake state cannot be set to HasAppKeys; current state is " + this.handshakeState);
            }
        }
        this.connectionState = QuicConnectionImpl.Status.Connected;
        this.handshakeFinishedCondition.countDown();
    }

    @Override
    public void newSessionTicketReceived(NewSessionTicket ticket) {
        this.addNewSessionTicket(ticket);
    }

    @Override
    public void extensionsReceived(List<Extension> extensions) {
        extensions.forEach(ex -> {
            if (ex instanceof EarlyDataExtension) {
                this.setEarlyDataStatus(EarlyDataStatus.Accepted);
                this.log.info("Server has accepted early data.");
            } else if (ex instanceof QuicTransportParametersExtension) {
                this.setPeerTransportParameters(((QuicTransportParametersExtension)ex).getTransportParameters());
            }
        });
    }

    private void discard(PnSpace pnSpace, String reason) {
        this.sender.discard(pnSpace, reason);
    }

    @Override
    public PacketProcessor.ProcessResult process(InitialPacket packet, Instant time) {
        this.destConnectionIds.replaceInitialConnectionId(packet.getSourceConnectionId());
        this.processFrames(packet, time);
        this.ignoreVersionNegotiation = true;
        return PacketProcessor.ProcessResult.Continue;
    }

    @Override
    public PacketProcessor.ProcessResult process(HandshakePacket packet, Instant time) {
        this.processFrames(packet, time);
        return PacketProcessor.ProcessResult.Continue;
    }

    @Override
    public PacketProcessor.ProcessResult process(ShortHeaderPacket packet, Instant time) {
        if (this.sourceConnectionIds.registerUsedConnectionId(packet.getDestinationConnectionId()) && !this.sourceConnectionIds.limitReached()) {
            this.newConnectionIds(1, 0);
        }
        this.processFrames(packet, time);
        return PacketProcessor.ProcessResult.Continue;
    }

    @Override
    public PacketProcessor.ProcessResult process(VersionNegotiationPacket vnPacket, Instant time) {
        if (!this.ignoreVersionNegotiation && !vnPacket.getServerSupportedVersions().contains((Object)this.quicVersion)) {
            this.log.info("Server doesn't support " + this.quicVersion + ", but only: " + vnPacket.getServerSupportedVersions().stream().map(v -> v.toString()).collect(Collectors.joining(", ")));
            throw new VersionNegotiationFailure();
        }
        this.log.debug("Ignoring Version Negotiation packet");
        return PacketProcessor.ProcessResult.Continue;
    }

    @Override
    public PacketProcessor.ProcessResult process(RetryPacket packet, Instant time) {
        if (packet.validateIntegrityTag(this.destConnectionIds.getCurrent())) {
            if (!this.processedRetryPacket) {
                this.processedRetryPacket = true;
                this.token = packet.getRetryToken();
                this.sender.setInitialToken(this.token);
                this.getCryptoStream(EncryptionLevel.Initial).reset();
                byte[] destConnectionId = packet.getSourceConnectionId();
                this.destConnectionIds.replaceInitialConnectionId(destConnectionId);
                this.destConnectionIds.setRetrySourceConnectionId(destConnectionId);
                this.log.debug("Changing destination connection id into: " + ByteUtils.bytesToHex(destConnectionId));
                this.generateInitialKeys();
                this.sender.getCongestionController().reset();
                try {
                    this.tlsEngine.startHandshake();
                }
                catch (IOException iOException) {}
            } else {
                this.log.error("Ignoring RetryPacket, because already processed one.");
            }
        } else {
            this.log.error("Discarding Retry packet, because integrity tag is invalid.");
        }
        return PacketProcessor.ProcessResult.Continue;
    }

    @Override
    public PacketProcessor.ProcessResult process(ZeroRttPacket packet, Instant time) {
        return PacketProcessor.ProcessResult.Abort;
    }

    @Override
    public void process(AckFrame ackFrame, QuicPacket packet, Instant timeReceived) {
        if (this.peerTransportParams != null) {
            ackFrame.setDelayExponent(this.peerTransportParams.getAckDelayExponent());
        }
        this.ackProcessors.forEach(p -> p.process(ackFrame, packet.getPnSpace(), timeReceived));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(HandshakeDoneFrame handshakeDoneFrame, QuicPacket packet, Instant timeReceived) {
        HandshakeState handshakeState = this.handshakeState;
        synchronized (handshakeState) {
            if (this.handshakeState.transitionAllowed(HandshakeState.Confirmed)) {
                this.handshakeState = HandshakeState.Confirmed;
                this.handshakeStateListeners.forEach(l -> l.handshakeStateChangedEvent(this.handshakeState));
            } else {
                this.log.debug("Handshake state cannot be set to Confirmed");
            }
        }
        this.sender.discard(PnSpace.Handshake, "HandshakeDone is received");
    }

    @Override
    public void process(NewConnectionIdFrame newConnectionIdFrame, QuicPacket packet, Instant timeReceived) {
        this.registerNewDestinationConnectionId(newConnectionIdFrame);
    }

    @Override
    public void process(NewTokenFrame newTokenFrame, QuicPacket packet, Instant timeReceived) {
    }

    @Override
    public void process(PathChallengeFrame pathChallengeFrame, QuicPacket packet, Instant timeReceived) {
        PathResponseFrame response = new PathResponseFrame(this.quicVersion, pathChallengeFrame.getData());
        this.send(response, f -> {});
    }

    @Override
    public void process(RetireConnectionIdFrame retireConnectionIdFrame, QuicPacket packet, Instant timeReceived) {
        this.retireSourceConnectionId(retireConnectionIdFrame);
    }

    @Override
    public void process(QuicFrame frame, QuicPacket packet, Instant timeReceived) {
        this.log.warn("Unhandled frame type: " + frame);
    }

    @Override
    protected void immediateCloseWithError(EncryptionLevel level, int error, String errorReason) {
        if (this.keepAliveActor != null) {
            this.keepAliveActor.shutdown();
        }
        super.immediateCloseWithError(level, error, errorReason);
    }

    @Override
    protected void terminate() {
        super.terminate();
        this.handshakeFinishedCondition.countDown();
        this.receiver.shutdown();
        this.socket.close();
        if (this.receiverThread != null) {
            this.receiverThread.interrupt();
        }
    }

    public void changeAddress() {
        try {
            DatagramSocket newSocket = new DatagramSocket();
            this.sender.changeAddress(newSocket);
            this.receiver.changeAddress(newSocket);
            this.log.info("Changed local address to " + newSocket.getLocalPort());
        }
        catch (SocketException e) {
            this.log.error("Changing local address failed", e);
        }
    }

    public void updateKeys() {
        if (this.handshakeState == HandshakeState.Confirmed) {
            this.connectionSecrets.getClientSecrets(EncryptionLevel.App).computeKeyUpdate(true);
        } else {
            this.log.error("Refusing key update because handshake is not yet confirmed");
        }
    }

    @Override
    public int getMaxShortHeaderPacketOverhead() {
        return 1 + this.destConnectionIds.getConnectionIdlength() + 4 + 16;
    }

    public TransportParameters getTransportParameters() {
        return this.transportParams;
    }

    public TransportParameters getPeerTransportParameters() {
        return this.peerTransportParams;
    }

    void setPeerTransportParameters(TransportParameters transportParameters) {
        this.setPeerTransportParameters(transportParameters, true);
    }

    private void setPeerTransportParameters(TransportParameters transportParameters, boolean validate) {
        if (validate && !this.verifyConnectionIds(transportParameters)) {
            return;
        }
        this.peerTransportParams = transportParameters;
        if (this.flowController == null) {
            this.flowController = new FlowControl(Role.Client, this.peerTransportParams.getInitialMaxData(), this.peerTransportParams.getInitialMaxStreamDataBidiLocal(), this.peerTransportParams.getInitialMaxStreamDataBidiRemote(), this.peerTransportParams.getInitialMaxStreamDataUni(), this.log);
            this.streamManager.setFlowController(this.flowController);
        } else {
            this.log.debug("Updating flow controller with new transport parameters");
            this.flowController.updateInitialValues(this.peerTransportParams);
        }
        this.streamManager.setInitialMaxStreamsBidi(this.peerTransportParams.getInitialMaxStreamsBidi());
        this.streamManager.setInitialMaxStreamsUni(this.peerTransportParams.getInitialMaxStreamsUni());
        this.sender.setReceiverMaxAckDelay(this.peerTransportParams.getMaxAckDelay());
        this.sourceConnectionIds.setActiveLimit(this.peerTransportParams.getActiveConnectionIdLimit());
        this.determineIdleTimeout(this.transportParams.getMaxIdleTimeout(), this.peerTransportParams.getMaxIdleTimeout());
        if (this.processedRetryPacket) {
            if (this.peerTransportParams.getRetrySourceConnectionId() == null || !Arrays.equals(this.destConnectionIds.getRetrySourceConnectionId(), this.peerTransportParams.getRetrySourceConnectionId())) {
                this.immediateCloseWithError(EncryptionLevel.Handshake, QuicConstants.TransportErrorCode.TRANSPORT_PARAMETER_ERROR.value, "incorrect retry_source_connection_id transport parameter");
            }
        } else if (this.peerTransportParams.getRetrySourceConnectionId() != null) {
            this.immediateCloseWithError(EncryptionLevel.Handshake, QuicConstants.TransportErrorCode.TRANSPORT_PARAMETER_ERROR.value, "unexpected retry_source_connection_id transport parameter");
        }
    }

    private boolean verifyConnectionIds(TransportParameters transportParameters) {
        if (transportParameters.getInitialSourceConnectionId() == null || transportParameters.getOriginalDestinationConnectionId() == null) {
            this.log.error("Missing connection id from server transport parameter");
            if (transportParameters.getInitialSourceConnectionId() == null) {
                this.immediateCloseWithError(EncryptionLevel.Handshake, QuicConstants.TransportErrorCode.TRANSPORT_PARAMETER_ERROR.value, "missing initial_source_connection_id transport parameter");
            } else {
                this.immediateCloseWithError(EncryptionLevel.Handshake, QuicConstants.TransportErrorCode.TRANSPORT_PARAMETER_ERROR.value, "missing original_destination_connection_id transport parameter");
            }
            return false;
        }
        if (!Arrays.equals(this.destConnectionIds.getCurrent(), transportParameters.getInitialSourceConnectionId())) {
            this.log.error("Source connection id does not match corresponding transport parameter");
            this.immediateCloseWithError(EncryptionLevel.Handshake, QuicConstants.TransportErrorCode.PROTOCOL_VIOLATION.value, "initial_source_connection_id transport parameter does not match");
            return false;
        }
        if (!Arrays.equals(this.destConnectionIds.getOriginalConnectionId(), transportParameters.getOriginalDestinationConnectionId())) {
            this.log.error("Original destination connection id does not match corresponding transport parameter");
            this.immediateCloseWithError(EncryptionLevel.Handshake, QuicConstants.TransportErrorCode.PROTOCOL_VIOLATION.value, "original_destination_connection_id transport parameter does not match");
            return false;
        }
        return true;
    }

    @Override
    public void abortConnection(Throwable error) {
        this.connectionState = QuicConnectionImpl.Status.Closing;
        if (error != null) {
            this.log.error("Aborting connection because of error", error);
        }
        this.handshakeFinishedCondition.countDown();
        this.terminate();
        this.streamManager.abortAll();
    }

    protected void registerNewDestinationConnectionId(NewConnectionIdFrame frame) {
        boolean addedNew = this.destConnectionIds.registerNewConnectionId(frame.getSequenceNr(), frame.getConnectionId());
        if (!addedNew) {
            this.retireDestinationConnectionId(frame.getSequenceNr());
        }
        if (frame.getRetirePriorTo() > 0) {
            List<Integer> retired = this.destConnectionIds.retireAllBefore(frame.getRetirePriorTo());
            retired.forEach(retiredCid -> this.retireDestinationConnectionId((Integer)retiredCid));
            this.log.info("Peer requests to retire connection ids; switching to destination connection id ", this.destConnectionIds.getCurrent());
        }
    }

    public byte[] nextDestinationConnectionId() {
        byte[] newConnectionId = this.destConnectionIds.useNext();
        this.log.debug("Switching to next destination connection id: " + ByteUtils.bytesToHex(newConnectionId));
        return newConnectionId;
    }

    public byte[][] newConnectionIds(int count, int retirePriorTo) {
        byte[][] newConnectionIds = new byte[count][];
        for (int i = 0; i < count; ++i) {
            ConnectionIdInfo cid = this.sourceConnectionIds.generateNew();
            newConnectionIds[i] = cid.getConnectionId();
            this.log.debug("New generated source connection id", cid.getConnectionId());
            this.sender.send(new NewConnectionIdFrame(this.quicVersion, cid.getSequenceNumber(), retirePriorTo, cid.getConnectionId()), EncryptionLevel.App);
        }
        this.sender.flush();
        return newConnectionIds;
    }

    public void retireDestinationConnectionId(Integer sequenceNumber) {
        this.send(new RetireConnectionIdFrame(this.quicVersion, sequenceNumber), lostFrame -> this.retireDestinationConnectionId(sequenceNumber));
        this.destConnectionIds.retireConnectionId(sequenceNumber);
    }

    private void retireSourceConnectionId(RetireConnectionIdFrame frame) {
        int sequenceNr = frame.getSequenceNr();
        this.sourceConnectionIds.retireConnectionId(sequenceNr);
        if (!this.sourceConnectionIds.limitReached()) {
            this.newConnectionIds(1, 0);
        } else {
            this.log.debug("active connection id limit reached for peer, not sending new");
        }
    }

    @Override
    protected SenderImpl getSender() {
        return this.sender;
    }

    @Override
    protected GlobalAckGenerator getAckGenerator() {
        return this.ackGenerator;
    }

    @Override
    protected TlsClientEngine getTlsEngine() {
        return this.tlsEngine;
    }

    @Override
    protected StreamManager getStreamManager() {
        return this.streamManager;
    }

    @Override
    protected int getSourceConnectionIdLength() {
        return this.sourceConnectionIds.getConnectionIdlength();
    }

    @Override
    public byte[] getSourceConnectionId() {
        return this.sourceConnectionIds.getCurrent();
    }

    public Map<Integer, ConnectionIdInfo> getSourceConnectionIds() {
        return this.sourceConnectionIds.getAll();
    }

    @Override
    public byte[] getDestinationConnectionId() {
        return this.destConnectionIds.getCurrent();
    }

    public Map<Integer, ConnectionIdInfo> getDestinationConnectionIds() {
        return this.destConnectionIds.getAll();
    }

    @Override
    public void setPeerInitiatedStreamCallback(Consumer<QuicStream> streamProcessor) {
        this.streamManager.setPeerInitiatedStreamCallback(streamProcessor);
    }

    @Override
    public long getInitialMaxStreamData() {
        return this.transportParams.getInitialMaxStreamDataBidiLocal();
    }

    @Override
    public void setMaxAllowedBidirectionalStreams(int max) {
        this.transportParams.setInitialMaxStreamsBidi(max);
    }

    @Override
    public void setMaxAllowedUnidirectionalStreams(int max) {
        this.transportParams.setInitialMaxStreamsUni(max);
    }

    @Override
    public void setDefaultStreamReceiveBufferSize(long size) {
        this.transportParams.setInitialMaxStreamData(size);
    }

    public FlowControl getFlowController() {
        return this.flowController;
    }

    public void addNewSessionTicket(NewSessionTicket tlsSessionTicket) {
        if (tlsSessionTicket.hasEarlyDataExtension() && tlsSessionTicket.getEarlyDataMaxSize() != 0xFFFFFFFFL) {
            this.log.error("Invalid quic new session ticket (invalid early data size); ignoring ticket.");
        }
        this.newSessionTickets.add(new QuicSessionTicket(tlsSessionTicket, this.peerTransportParams));
    }

    @Override
    public List<QuicSessionTicket> getNewSessionTickets() {
        return this.newSessionTickets;
    }

    public EarlyDataStatus getEarlyDataStatus() {
        return this.earlyDataStatus;
    }

    public void setEarlyDataStatus(EarlyDataStatus earlyDataStatus) {
        this.earlyDataStatus = earlyDataStatus;
    }

    public URI getUri() {
        try {
            return new URI("//" + this.host + ":" + this.port);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void registerProcessor(FrameProcessor2<AckFrame> ackProcessor) {
        this.ackProcessors.add(ackProcessor);
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.socket.getLocalSocketAddress();
    }

    @Override
    public InetSocketAddress getServerAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    @Override
    public List<X509Certificate> getServerCertificateChain() {
        return this.tlsEngine.getServerCertificateChain();
    }

    @Override
    public boolean isConnected() {
        return this.connectionState == QuicConnectionImpl.Status.Connected;
    }

    public void trustAll() {
        X509TrustManager trustAllCerts = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        };
        this.tlsEngine.setTrustManager(trustAllCerts);
    }

    private void enableQuantumReadinessTest(int nrDummyBytes) {
        this.clientHelloEnlargement = nrDummyBytes;
    }

    public static Builder newBuilder() {
        return new BuilderImpl();
    }

    private static class BuilderImpl
    implements Builder {
        private String host;
        private int port;
        private QuicSessionTicket sessionTicket;
        private Version quicVersion = Version.getDefault();
        private Logger log = new NullLogger();
        private String proxyHost;
        private Path secretsFile;
        private Integer initialRtt;
        private Integer connectionIdLength;
        private List<TlsConstants.CipherSuite> cipherSuites = new ArrayList<TlsConstants.CipherSuite>();
        private boolean omitCertificateCheck;
        private Integer quantumReadinessTest;
        private X509Certificate clientCertificate;
        private PrivateKey clientCertificateKey;

        private BuilderImpl() {
        }

        @Override
        public QuicClientConnectionImpl build() throws SocketException, UnknownHostException {
            if (!this.quicVersion.atLeast(Version.IETF_draft_29)) {
                throw new IllegalArgumentException("Quic version " + this.quicVersion + " not supported");
            }
            if (this.host == null) {
                throw new IllegalStateException("Cannot create connection when URI is not set");
            }
            if (this.initialRtt != null && this.initialRtt < 1) {
                throw new IllegalArgumentException("Initial RTT must be larger than 0.");
            }
            if (this.cipherSuites.isEmpty()) {
                this.cipherSuites.add(TlsConstants.CipherSuite.TLS_AES_128_GCM_SHA256);
            }
            long start = System.currentTimeMillis();
            QuicClientConnectionImpl quicConnection = new QuicClientConnectionImpl(this.host, this.port, this.sessionTicket, this.quicVersion, this.log, this.proxyHost, this.secretsFile, this.initialRtt, this.connectionIdLength, this.cipherSuites, this.clientCertificate, this.clientCertificateKey);
            long end = System.currentTimeMillis();
            System.out.println("================= new QuicClientConnectionImpl " + (end - start) + " ms");
            if (this.omitCertificateCheck) {
                quicConnection.trustAll();
            }
            if (this.quantumReadinessTest != null) {
                quicConnection.enableQuantumReadinessTest(this.quantumReadinessTest);
            }
            return quicConnection;
        }

        @Override
        public Builder connectTimeout(Duration duration) {
            return this;
        }

        @Override
        public Builder version(Version version) {
            this.quicVersion = version;
            return this;
        }

        @Override
        public Builder logger(Logger log) {
            this.log = log;
            return this;
        }

        @Override
        public Builder sessionTicket(QuicSessionTicket ticket) {
            this.sessionTicket = ticket;
            return this;
        }

        @Override
        public Builder proxy(String host) {
            this.proxyHost = host;
            return this;
        }

        @Override
        public Builder secrets(Path secretsFile) {
            this.secretsFile = secretsFile;
            return this;
        }

        @Override
        public Builder uri(URI uri) {
            this.host = uri.getHost();
            this.port = uri.getPort();
            return this;
        }

        @Override
        public Builder connectionIdLength(int length) {
            if (length < 0 || length > 20) {
                throw new IllegalArgumentException("Connection ID length must between 0 and 20.");
            }
            this.connectionIdLength = length;
            return this;
        }

        @Override
        public Builder initialRtt(int initialRtt) {
            this.initialRtt = initialRtt;
            return this;
        }

        @Override
        public Builder cipherSuite(TlsConstants.CipherSuite cipherSuite) {
            this.cipherSuites.add(cipherSuite);
            return this;
        }

        @Override
        public Builder noServerCertificateCheck() {
            this.omitCertificateCheck = true;
            return this;
        }

        @Override
        public Builder quantumReadinessTest(int nrOfDummyBytes) {
            this.quantumReadinessTest = nrOfDummyBytes;
            return this;
        }

        @Override
        public Builder clientCertificate(X509Certificate certificate) {
            this.clientCertificate = certificate;
            return this;
        }

        @Override
        public Builder clientCertificateKey(PrivateKey privateKey) {
            this.clientCertificateKey = privateKey;
            return this;
        }
    }

    public static interface Builder {
        public QuicClientConnectionImpl build() throws SocketException, UnknownHostException;

        public Builder connectTimeout(Duration var1);

        public Builder version(Version var1);

        public Builder logger(Logger var1);

        public Builder sessionTicket(QuicSessionTicket var1);

        public Builder proxy(String var1);

        public Builder secrets(Path var1);

        public Builder uri(URI var1);

        public Builder connectionIdLength(int var1);

        public Builder initialRtt(int var1);

        public Builder cipherSuite(TlsConstants.CipherSuite var1);

        public Builder noServerCertificateCheck();

        public Builder quantumReadinessTest(int var1);

        public Builder clientCertificate(X509Certificate var1);

        public Builder clientCertificateKey(PrivateKey var1);
    }
}

