/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.luminis.quic.EncryptionLevel;
import net.luminis.quic.Version;
import net.luminis.quic.frame.PingFrame;
import net.luminis.quic.send.Sender;

public class KeepAliveActor {
    private final Version quicVersion;
    private final int keepAliveTime;
    private final int peerIdleTimeout;
    private final Sender sender;
    private final Instant started;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final int pingInterval;
    private volatile ScheduledFuture<?> scheduledTask;

    public KeepAliveActor(Version quicVersion, int keepAliveTime, int peerIdleTimeout, Sender sender) {
        this.quicVersion = quicVersion;
        this.keepAliveTime = keepAliveTime;
        this.peerIdleTimeout = peerIdleTimeout;
        this.sender = sender;
        this.started = Instant.now();
        this.pingInterval = peerIdleTimeout / 2;
        this.scheduleNextPing();
    }

    private void ping() {
        this.sender.send(new PingFrame(this.quicVersion), EncryptionLevel.App);
        this.scheduleNextPing();
    }

    private void scheduleNextPing() {
        Instant now = Instant.now();
        if (Duration.between(this.started, now).compareTo(Duration.of(this.keepAliveTime - this.pingInterval, ChronoUnit.SECONDS)) < 0) {
            this.scheduledTask = this.scheduler.schedule(() -> this.ping(), (long)this.pingInterval, TimeUnit.SECONDS);
        }
    }

    public void shutdown() {
        this.scheduler.shutdown();
    }
}

