/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic;

import java.time.Instant;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.IntSupplier;
import net.luminis.quic.QuicConnectionImpl;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.QuicPacket;

public class IdleTimer {
    private final Timer timer;
    private final int timerResolution;
    private long timeout;
    private final QuicConnectionImpl connection;
    private final Logger log;
    private volatile IntSupplier ptoSupplier;
    private volatile Instant lastAction;
    private volatile boolean enabled;

    public IdleTimer(QuicConnectionImpl connection, Logger logger) {
        this(connection, logger, 1000);
    }

    public IdleTimer(QuicConnectionImpl connection, Logger logger, int timerResolution) {
        this.connection = connection;
        this.ptoSupplier = () -> 0;
        this.log = logger;
        this.timerResolution = timerResolution;
        this.timer = new Timer(true);
        this.lastAction = Instant.now();
    }

    void setIdleTimeout(long idleTimeoutInMillis) {
        if (!this.enabled) {
            this.enabled = true;
            this.timeout = idleTimeoutInMillis;
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    IdleTimer.this.checkIdle();
                }
            }, this.timerResolution, (long)this.timerResolution);
        } else {
            this.log.error("idle timeout was set already; can't be set twice on same connection");
        }
    }

    public void setPtoSupplier(IntSupplier ptoSupplier) {
        this.ptoSupplier = ptoSupplier;
    }

    private void checkIdle() {
        if (this.enabled) {
            int currentPto;
            Instant now = Instant.now();
            if (this.lastAction.plusMillis(this.timeout).isBefore(now) && this.lastAction.plusMillis(3 * (currentPto = this.ptoSupplier.getAsInt())).isBefore(now)) {
                this.timer.cancel();
                this.connection.silentlyCloseConnection(this.timeout + (long)currentPto);
            }
        }
    }

    public void packetProcessed() {
        if (this.enabled) {
            this.lastAction = Instant.now();
        }
    }

    public void packetSent(QuicPacket packet, Instant sendTime) {
        if (this.enabled && packet.isAckEliciting()) {
            this.lastAction = sendTime;
        }
    }

    public void shutdown() {
        if (this.enabled) {
            this.timer.cancel();
        }
    }
}

