/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.luminis.quic.EncryptionLevel;
import net.luminis.quic.Role;
import net.luminis.quic.Version;
import net.luminis.quic.crypto.ConnectionSecrets;
import net.luminis.quic.frame.CryptoFrame;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.log.Logger;
import net.luminis.quic.send.Sender;
import net.luminis.quic.stream.BaseStream;
import net.luminis.quic.tls.QuicTransportParametersExtension;
import net.luminis.tls.Message;
import net.luminis.tls.ProtectionKeysType;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.TlsProtocolException;
import net.luminis.tls.extension.Extension;
import net.luminis.tls.handshake.HandshakeMessage;
import net.luminis.tls.handshake.TlsEngine;
import net.luminis.tls.handshake.TlsMessageParser;

public class CryptoStream
extends BaseStream {
    private final Version quicVersion;
    private final EncryptionLevel encryptionLevel;
    private final ProtectionKeysType tlsProtectionType;
    private final ConnectionSecrets connectionSecrets;
    private final Role peerRole;
    private final TlsEngine tlsEngine;
    private final Logger log;
    private final Sender sender;
    private final List<Message> messagesReceived;
    private final List<Message> messagesSent;
    private final TlsMessageParser tlsMessageParser;
    private final List<ByteBuffer> dataToSend;
    private volatile int dataToSendOffset;
    private volatile int sendStreamSize;
    private boolean msgSizeRead = false;
    private int msgSize;
    private byte msgType;

    public CryptoStream(Version quicVersion, EncryptionLevel encryptionLevel, ConnectionSecrets connectionSecrets, Role role, TlsEngine tlsEngine, Logger log, Sender sender) {
        this.quicVersion = quicVersion;
        this.encryptionLevel = encryptionLevel;
        this.connectionSecrets = connectionSecrets;
        this.peerRole = role.other();
        this.tlsEngine = tlsEngine;
        this.log = log;
        this.sender = sender;
        this.tlsProtectionType = encryptionLevel == EncryptionLevel.Handshake ? ProtectionKeysType.Handshake : (encryptionLevel == EncryptionLevel.App ? ProtectionKeysType.Application : ProtectionKeysType.None);
        this.messagesReceived = new ArrayList<Message>();
        this.messagesSent = new ArrayList<Message>();
        this.tlsMessageParser = new TlsMessageParser(this::quicExtensionsParser);
        this.dataToSend = new ArrayList<ByteBuffer>();
    }

    public void add(CryptoFrame cryptoFrame) throws TlsProtocolException {
        try {
            if (super.add(cryptoFrame)) {
                int availableBytes = this.bytesAvailable();
                while (this.msgSizeRead && availableBytes >= this.msgSize || !this.msgSizeRead && availableBytes >= 4) {
                    if (!this.msgSizeRead && availableBytes >= 4) {
                        ByteBuffer buffer = ByteBuffer.allocate(4);
                        this.read(buffer);
                        this.msgType = buffer.get(0);
                        buffer.put(0, (byte)0);
                        buffer.flip();
                        this.msgSize = buffer.getInt();
                        this.msgSizeRead = true;
                        availableBytes -= 4;
                    }
                    if (!this.msgSizeRead || availableBytes < this.msgSize) continue;
                    ByteBuffer msgBuffer = ByteBuffer.allocate(4 + this.msgSize);
                    msgBuffer.putInt(this.msgSize);
                    msgBuffer.put(0, this.msgType);
                    int read = this.read(msgBuffer);
                    availableBytes -= read;
                    this.msgSizeRead = false;
                    msgBuffer.flip();
                    HandshakeMessage tlsMessage = this.tlsMessageParser.parseAndProcessHandshakeMessage(msgBuffer, this.tlsEngine, this.tlsProtectionType);
                    if (msgBuffer.hasRemaining()) {
                        throw new RuntimeException();
                    }
                    this.messagesReceived.add(tlsMessage);
                }
            } else {
                this.log.debug("Discarding " + cryptoFrame + ", because stream already parsed to " + this.readOffset());
            }
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    Extension quicExtensionsParser(ByteBuffer buffer, TlsConstants.HandshakeType context) throws TlsProtocolException {
        buffer.mark();
        short extensionType = buffer.getShort();
        buffer.reset();
        if (QuicTransportParametersExtension.isCodepoint(this.quicVersion, extensionType & 0xFFFF)) {
            return new QuicTransportParametersExtension(this.quicVersion).parse(buffer, this.peerRole, this.log);
        }
        return null;
    }

    public String toString() {
        return this.toStringWith(Collections.emptyList());
    }

    public String toStringReceived() {
        return this.toStringWith(this.messagesReceived);
    }

    public String toStringSent() {
        return this.toStringWith(this.messagesSent);
    }

    private String toStringWith(List<Message> messages) {
        return "CryptoStream[" + this.encryptionLevel.name().charAt(0) + "|" + messages.stream().map(msg -> msg.getClass().getSimpleName()).map(name -> name.endsWith("Message") ? name.substring(0, name.length() - 7) : name).collect(Collectors.joining(",")) + "]";
    }

    public List<Message> getTlsMessages() {
        return this.messagesReceived;
    }

    public void write(HandshakeMessage message, boolean flush) {
        this.write(message.getBytes());
        if (flush) {
            this.sender.flush();
        }
        this.messagesSent.add(message);
    }

    void write(byte[] data) {
        this.dataToSend.add(ByteBuffer.wrap(data));
        this.sendStreamSize += data.length;
        this.sender.send(this::sendFrame, 10, this.encryptionLevel, this::retransmitCrypto);
    }

    private QuicFrame sendFrame(int maxSize) {
        int bytesToCopy;
        int leftToSend = this.sendStreamSize - this.dataToSendOffset;
        int bytesToSend = Integer.min(leftToSend, maxSize - 10);
        if (bytesToSend == 0) {
            return null;
        }
        if (bytesToSend < leftToSend) {
            this.sender.send(this::sendFrame, 10, this.encryptionLevel, this::retransmitCrypto);
        }
        byte[] frameData = new byte[bytesToSend];
        for (int frameDataOffset = 0; frameDataOffset < bytesToSend; frameDataOffset += bytesToCopy) {
            bytesToCopy = Integer.min(bytesToSend - frameDataOffset, this.dataToSend.get(0).remaining());
            this.dataToSend.get(0).get(frameData, frameDataOffset, bytesToCopy);
            if (this.dataToSend.get(0).remaining() != 0) continue;
            this.dataToSend.remove(0);
        }
        CryptoFrame frame = new CryptoFrame(this.quicVersion, this.dataToSendOffset, frameData);
        this.dataToSendOffset += bytesToSend;
        return frame;
    }

    private void retransmitCrypto(QuicFrame cryptoFrame) {
        this.log.recovery("Retransmitting " + cryptoFrame + " on level " + this.encryptionLevel);
        this.sender.send(cryptoFrame, this.encryptionLevel, this::retransmitCrypto);
    }

    public void reset() {
        this.dataToSendOffset = 0;
        this.sendStreamSize = 0;
        this.dataToSend.clear();
    }
}

